"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeCasesPermissions = exports.writeCasesCapabilities = exports.readCasesPermissions = exports.readCasesCapabilities = exports.onlyDeleteCasesPermission = exports.noUpdateCasesPermissions = exports.noPushCasesPermissions = exports.noDeleteCasesPermissions = exports.noCreateCasesPermissions = exports.noCasesPermissions = exports.noCasesCapabilities = exports.buildCasesPermissions = exports.buildCasesCapabilities = exports.allCasesPermissions = exports.allCasesCapabilities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allCasesPermissions = () => buildCasesPermissions();
exports.allCasesPermissions = allCasesPermissions;
const noCasesPermissions = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: false,
  push: false
});
exports.noCasesPermissions = noCasesPermissions;
const readCasesPermissions = () => buildCasesPermissions({
  read: true,
  create: false,
  update: false,
  delete: false,
  push: false
});
exports.readCasesPermissions = readCasesPermissions;
const noCreateCasesPermissions = () => buildCasesPermissions({
  create: false
});
exports.noCreateCasesPermissions = noCreateCasesPermissions;
const noUpdateCasesPermissions = () => buildCasesPermissions({
  update: false
});
exports.noUpdateCasesPermissions = noUpdateCasesPermissions;
const noPushCasesPermissions = () => buildCasesPermissions({
  push: false
});
exports.noPushCasesPermissions = noPushCasesPermissions;
const noDeleteCasesPermissions = () => buildCasesPermissions({
  delete: false
});
exports.noDeleteCasesPermissions = noDeleteCasesPermissions;
const writeCasesPermissions = () => buildCasesPermissions({
  read: false
});
exports.writeCasesPermissions = writeCasesPermissions;
const onlyDeleteCasesPermission = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: true,
  push: false
});
exports.onlyDeleteCasesPermission = onlyDeleteCasesPermission;
const buildCasesPermissions = (overrides = {}) => {
  var _overrides$create, _overrides$read, _overrides$update, _overrides$delete, _overrides$push;
  const create = (_overrides$create = overrides.create) !== null && _overrides$create !== void 0 ? _overrides$create : true;
  const read = (_overrides$read = overrides.read) !== null && _overrides$read !== void 0 ? _overrides$read : true;
  const update = (_overrides$update = overrides.update) !== null && _overrides$update !== void 0 ? _overrides$update : true;
  const deletePermissions = (_overrides$delete = overrides.delete) !== null && _overrides$delete !== void 0 ? _overrides$delete : true;
  const push = (_overrides$push = overrides.push) !== null && _overrides$push !== void 0 ? _overrides$push : true;
  const all = create && read && update && deletePermissions && push;
  return {
    all,
    create,
    read,
    update,
    delete: deletePermissions,
    push
  };
};
exports.buildCasesPermissions = buildCasesPermissions;
const allCasesCapabilities = () => buildCasesCapabilities();
exports.allCasesCapabilities = allCasesCapabilities;
const noCasesCapabilities = () => buildCasesCapabilities({
  create_cases: false,
  read_cases: false,
  update_cases: false,
  delete_cases: false,
  push_cases: false
});
exports.noCasesCapabilities = noCasesCapabilities;
const readCasesCapabilities = () => buildCasesCapabilities({
  create_cases: false,
  update_cases: false,
  delete_cases: false,
  push_cases: false
});
exports.readCasesCapabilities = readCasesCapabilities;
const writeCasesCapabilities = () => {
  return buildCasesCapabilities({
    read_cases: false
  });
};
exports.writeCasesCapabilities = writeCasesCapabilities;
const buildCasesCapabilities = overrides => {
  var _overrides$create_cas, _overrides$read_cases, _overrides$update_cas, _overrides$delete_cas, _overrides$push_cases;
  return {
    create_cases: (_overrides$create_cas = overrides === null || overrides === void 0 ? void 0 : overrides.create_cases) !== null && _overrides$create_cas !== void 0 ? _overrides$create_cas : true,
    read_cases: (_overrides$read_cases = overrides === null || overrides === void 0 ? void 0 : overrides.read_cases) !== null && _overrides$read_cases !== void 0 ? _overrides$read_cases : true,
    update_cases: (_overrides$update_cas = overrides === null || overrides === void 0 ? void 0 : overrides.update_cases) !== null && _overrides$update_cas !== void 0 ? _overrides$update_cas : true,
    delete_cases: (_overrides$delete_cas = overrides === null || overrides === void 0 ? void 0 : overrides.delete_cases) !== null && _overrides$delete_cas !== void 0 ? _overrides$delete_cas : true,
    push_cases: (_overrides$push_cases = overrides === null || overrides === void 0 ? void 0 : overrides.push_cases) !== null && _overrides$push_cases !== void 0 ? _overrides$push_cases : true
  };
};
exports.buildCasesCapabilities = buildCasesCapabilities;