"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesStatus = exports.getCasesMetrics = exports.getCases = exports.bulkGetCases = void 0;
var _constants = require("../../common/constants");
var _utils = require("./utils");
var _decoders = require("./decoders");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCases = async ({
  http,
  signal,
  query
}) => {
  const res = await http.get(_constants.CASE_FIND_URL, {
    query,
    signal
  });
  return (0, _utils.convertAllCasesToCamel)((0, _decoders.decodeCasesFindResponse)(res));
};
exports.getCases = getCases;
const getCasesStatus = async ({
  http,
  query,
  signal
}) => {
  const response = await http.get(_constants.CASE_STATUS_URL, {
    signal,
    query
  });
  return (0, _utils.convertToCamelCase)((0, _decoders.decodeCasesStatusResponse)(response));
};
exports.getCasesStatus = getCasesStatus;
const getCasesMetrics = async ({
  http,
  signal,
  query
}) => {
  const res = await http.get(_constants.CASE_METRICS_URL, {
    signal,
    query
  });
  return (0, _utils.convertToCamelCase)((0, _decoders.decodeCasesMetricsResponse)(res));
};
exports.getCasesMetrics = getCasesMetrics;
const bulkGetCases = async ({
  http,
  signal,
  params
}) => {
  const res = await http.post(_constants.INTERNAL_BULK_GET_CASES_URL, {
    body: JSON.stringify({
      ...params
    }),
    signal
  });
  return (0, _decoders.decodeCasesBulkGetResponse)(res);
};
exports.bulkGetCases = bulkGetCases;