"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorMappingsRt = exports.ConnectorMappingsAttributesRt = exports.ConnectorMappingResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionTypeRt = rt.union([rt.literal('append'), rt.literal('nothing'), rt.literal('overwrite')]);
const CaseFieldRt = rt.union([rt.literal('title'), rt.literal('description'), rt.literal('comments'), rt.literal('tags')]);
const ThirdPartyFieldRt = rt.union([rt.string, rt.literal('not_mapped')]);
const ConnectorMappingRt = rt.strict({
  action_type: ActionTypeRt,
  source: CaseFieldRt,
  target: ThirdPartyFieldRt
});
const ConnectorMappingsRt = rt.array(ConnectorMappingRt);
exports.ConnectorMappingsRt = ConnectorMappingsRt;
const ConnectorMappingsAttributesRt = rt.strict({
  mappings: ConnectorMappingsRt,
  owner: rt.string
});
exports.ConnectorMappingsAttributesRt = ConnectorMappingsAttributesRt;
const ConnectorMappingResponseRt = rt.strict({
  id: rt.string,
  version: rt.string,
  mappings: ConnectorMappingsRt
});
exports.ConnectorMappingResponseRt = ConnectorMappingResponseRt;