"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NONE_CONNECTOR_ID = exports.FindActionConnectorResponseRt = exports.ConnectorTypes = exports.ConnectorTypeFieldsRt = exports.CaseUserActionConnectorRt = exports.CaseConnectorRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _jira = require("./jira");
var _resilient = require("./resilient");
var _servicenow_itsm = require("./servicenow_itsm");
var _servicenow_sir = require("./servicenow_sir");
var _swimlane = require("./swimlane");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConnectorTypes;
exports.ConnectorTypes = ConnectorTypes;
(function (ConnectorTypes) {
  ConnectorTypes["casesWebhook"] = ".cases-webhook";
  ConnectorTypes["jira"] = ".jira";
  ConnectorTypes["none"] = ".none";
  ConnectorTypes["resilient"] = ".resilient";
  ConnectorTypes["serviceNowITSM"] = ".servicenow";
  ConnectorTypes["serviceNowSIR"] = ".servicenow-sir";
  ConnectorTypes["swimlane"] = ".swimlane";
})(ConnectorTypes || (exports.ConnectorTypes = ConnectorTypes = {}));
const ConnectorCasesWebhookTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.casesWebhook),
  fields: rt.null
});
const ConnectorJiraTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.jira),
  fields: rt.union([_jira.JiraFieldsRT, rt.null])
});
const ConnectorResilientTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.resilient),
  fields: rt.union([_resilient.ResilientFieldsRT, rt.null])
});
const ConnectorServiceNowITSMTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowITSM),
  fields: rt.union([_servicenow_itsm.ServiceNowITSMFieldsRT, rt.null])
});
const ConnectorSwimlaneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.swimlane),
  fields: rt.union([_swimlane.SwimlaneFieldsRT, rt.null])
});
const ConnectorServiceNowSIRTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowSIR),
  fields: rt.union([_servicenow_sir.ServiceNowSIRFieldsRT, rt.null])
});
const ConnectorNoneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.none),
  fields: rt.null
});
const NONE_CONNECTOR_ID = 'none';
exports.NONE_CONNECTOR_ID = NONE_CONNECTOR_ID;
const ConnectorTypeFieldsRt = rt.union([ConnectorCasesWebhookTypeFieldsRt, ConnectorJiraTypeFieldsRt, ConnectorNoneTypeFieldsRt, ConnectorResilientTypeFieldsRt, ConnectorServiceNowITSMTypeFieldsRt, ConnectorServiceNowSIRTypeFieldsRt, ConnectorSwimlaneTypeFieldsRt]);

/**
 * This type represents the connector's format when it is encoded within a user action.
 */
exports.ConnectorTypeFieldsRt = ConnectorTypeFieldsRt;
const CaseUserActionConnectorRt = rt.union([rt.intersection([ConnectorCasesWebhookTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorJiraTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorNoneTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorResilientTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowITSMTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowSIRTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorSwimlaneTypeFieldsRt, rt.strict({
  name: rt.string
})])]);
exports.CaseUserActionConnectorRt = CaseUserActionConnectorRt;
const CaseConnectorRt = rt.intersection([rt.strict({
  id: rt.string
}), CaseUserActionConnectorRt]);
exports.CaseConnectorRt = CaseConnectorRt;
const ActionConnectorResultRt = rt.intersection([rt.strict({
  id: rt.string,
  actionTypeId: rt.string,
  name: rt.string,
  isDeprecated: rt.boolean,
  isPreconfigured: rt.boolean,
  referencedByCount: rt.number
}), rt.exact(rt.partial({
  config: rt.record(rt.string, rt.unknown),
  isMissingSecrets: rt.boolean
}))]);
const FindActionConnectorResponseRt = rt.array(ActionConnectorResultRt);
exports.FindActionConnectorResponseRt = FindActionConnectorResponseRt;