/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.canvas_bundle_jsonpfunction=window.canvas_bundle_jsonpfunction||[]).push([[2],{122:function(e,a,s){"use strict";s.d(a,"b",(function(){return Oe})),s.d(a,"a",(function(){return Ie}));var t=s(3),n=s(58);const l={help:t.i18n.translate("xpack.canvas.functions.allHelpText",{defaultMessage:"Returns {BOOLEAN_TRUE} if all of the conditions are met. See also {anyFn}.",values:{anyFn:"`any`",BOOLEAN_TRUE:n.b}}),args:{condition:t.i18n.translate("xpack.canvas.functions.all.args.conditionHelpText",{defaultMessage:"The conditions to check."})}};var i=s(0);const r={help:t.i18n.translate("xpack.canvas.functions.alterColumnHelpText",{defaultMessage:"Converts between core types, including {list}, and {end}, and renames columns. See also {mapColumnFn}, {mathColumnFn}, and {staticColumnFn}.",values:{list:Object.values(i.o).slice(0,-1).map((e=>`\`${e}\``)).join(", "),end:`\`${Object.values(i.o).slice(-1)[0]}\``,mapColumnFn:"`mapColumn`",staticColumnFn:"`staticColumn`",mathColumnFn:"`mathColumn`"}}),args:{column:t.i18n.translate("xpack.canvas.functions.alterColumn.args.columnHelpText",{defaultMessage:"The name of the column to alter."}),name:t.i18n.translate("xpack.canvas.functions.alterColumn.args.nameHelpText",{defaultMessage:"The resultant column name. Leave blank to not rename."}),type:t.i18n.translate("xpack.canvas.functions.alterColumn.args.typeHelpText",{defaultMessage:"The type to convert the column to. Leave blank to not change the type."})}},o={columnNotFound:e=>new Error(t.i18n.translate("xpack.canvas.functions.alterColumn.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}})),cannotConvertType:e=>new Error(t.i18n.translate("xpack.canvas.functions.alterColumn.cannotConvertTypeErrorMessage",{defaultMessage:"Cannot convert to '{type}'",values:{type:e}}))},c={help:t.i18n.translate("xpack.canvas.functions.anyHelpText",{defaultMessage:"Returns {BOOLEAN_TRUE} if at least one of the conditions is met. See also {all_fn}.",values:{all_fn:"`all`",BOOLEAN_TRUE:n.b}}),args:{condition:t.i18n.translate("xpack.canvas.functions.any.args.conditionHelpText",{defaultMessage:"The conditions to check."})}},u={help:t.i18n.translate("xpack.canvas.functions.asHelpText",{defaultMessage:"Creates a {DATATABLE} with a single value. See also {getCellFn}.",values:{DATATABLE:n.g,getCellFn:"`getCell`"}}),args:{name:t.i18n.translate("xpack.canvas.functions.as.args.nameHelpText",{defaultMessage:"The name to give the column."})}},p={help:t.i18n.translate("xpack.canvas.functions.assetHelpText",{defaultMessage:"Retrieves Canvas workpad asset objects to provide as argument values. Usually images."}),args:{id:t.i18n.translate("xpack.canvas.functions.asset.args.id",{defaultMessage:"The ID of the asset to retrieve."})}},g={invalidAssetId:e=>new Error(t.i18n.translate("xpack.canvas.functions.asset.invalidAssetId",{defaultMessage:"Could not get the asset by ID: '{assetId}'",values:{assetId:e},description:"This error occurs when there is no asset object associated with the given ID."}))};var d=s(69);const f={help:t.i18n.translate("xpack.canvas.functions.axisConfigHelpText",{defaultMessage:"Configures the axis of a visualization. Only used with {plotFn}.",values:{plotFn:"`plot`"}}),args:{max:t.i18n.translate("xpack.canvas.functions.axisConfig.args.maxHelpText",{defaultMessage:"The maximum value displayed in the axis. Must be a number, a date in milliseconds since epoch, or an {ISO8601} string.",values:{ISO8601:n.p}}),min:t.i18n.translate("xpack.canvas.functions.axisConfig.args.minHelpText",{defaultMessage:"The minimum value displayed in the axis. Must be a number, a date in milliseconds since epoch, or an {ISO8601} string.",values:{ISO8601:n.p}}),position:t.i18n.translate("xpack.canvas.functions.axisConfig.args.positionHelpText",{defaultMessage:"The position of the axis labels. For example, {list}, or {end}.",values:{list:Object.values(d.Position).slice(0,-1).map((e=>`\`"${e}"\``)).join(", "),end:`\`"${Object.values(d.Position).slice(-1)[0]}"\``}}),show:t.i18n.translate("xpack.canvas.functions.axisConfig.args.showHelpText",{defaultMessage:"Show the axis labels?"}),tickSize:t.i18n.translate("xpack.canvas.functions.axisConfig.args.tickSizeHelpText",{defaultMessage:"The increment size between each tick. Use for `number` axes only."})}},m={invalidPosition:e=>new Error(t.i18n.translate("xpack.canvas.functions.axisConfig.invalidPositionErrorMessage",{defaultMessage:"Invalid position: '{position}'",values:{position:e}})),invalidMinDateString:e=>new Error(t.i18n.translate("xpack.canvas.functions.axisConfig.invalidMinDateStringErrorMessage",{defaultMessage:"Invalid date string: '{min}'. 'min' must be a number, date in ms, or ISO8601 date string",values:{min:e}})),invalidMaxDateString:e=>new Error(t.i18n.translate("xpack.canvas.functions.axisConfig.invalidMaxPositionErrorMessage",{defaultMessage:"Invalid date string: '{max}'. 'max' must be a number, date in ms, or ISO8601 date string",values:{max:e}}))},v="`if`",x="`when`",h={help:t.i18n.translate("xpack.canvas.functions.caseHelpText",{defaultMessage:"Builds a {case}, including a condition and a result, to pass to the {switchFn} function.",values:{case:"`case`",switchFn:"`switch`"}}),args:{when:t.i18n.translate("xpack.canvas.functions.case.args.whenHelpText",{defaultMessage:"The value compared to the {CONTEXT} to see if they are equal. The {WHEN_ARG} argument is ignored when the {IF_ARG} argument is also specified.",values:{CONTEXT:n.d,IF_ARG:v,WHEN_ARG:x}}),if:t.i18n.translate("xpack.canvas.functions.case.args.ifHelpText",{defaultMessage:"This value indicates whether the condition is met. The {IF_ARG} argument overrides the {WHEN_ARG} argument when both are provided.",values:{IF_ARG:v,WHEN_ARG:x}}),then:t.i18n.translate("xpack.canvas.functions.case.args.thenHelpText",{defaultMessage:"The value returned if the condition is met."})}},T={help:t.i18n.translate("xpack.canvas.functions.clearHelpText",{defaultMessage:"Clears the {CONTEXT}, and returns {TYPE_NULL}.",values:{CONTEXT:n.d,TYPE_NULL:n.H}}),args:{}},M={help:t.i18n.translate("xpack.canvas.functions.columnsHelpText",{defaultMessage:"Includes or excludes columns from a {DATATABLE}. When both arguments are specified, the excluded columns will be removed first.",values:{DATATABLE:n.g}}),args:{include:t.i18n.translate("xpack.canvas.functions.columns.args.includeHelpText",{defaultMessage:"A comma-separated list of column names to keep in the {DATATABLE}.",values:{DATATABLE:n.g}}),exclude:t.i18n.translate("xpack.canvas.functions.columns.args.excludeHelpText",{defaultMessage:"A comma-separated list of column names to remove from the {DATATABLE}.",values:{DATATABLE:n.g}})}};var k=s(172);const y={help:t.i18n.translate("xpack.canvas.functions.compareHelpText",{defaultMessage:"Compares the {CONTEXT} to specified value to determine {BOOLEAN_TRUE} or {BOOLEAN_FALSE}. Usually used in combination with `{ifFn}` or `{caseFn}`. This only works with primitive types, such as {examples}. See also {eqFn}, {gtFn}, {gteFn}, {ltFn}, {lteFn}, {neqFn}",values:{CONTEXT:n.d,BOOLEAN_TRUE:n.b,BOOLEAN_FALSE:n.a,ifFn:"`if`",caseFn:"case",examples:[n.I,n.J,n.G,n.H].join(", "),eqFn:"`eq`",gtFn:"`gt`",gteFn:"`gte`",ltFn:"`lt`",lteFn:"`lte`",neqFn:"`neq`"}}),args:{op:t.i18n.translate("xpack.canvas.functions.compare.args.opHelpText",{defaultMessage:"The operator to use in the comparison: {eq} (equal to), {gt} (greater than), {gte} (greater than or equal to), {lt} (less than), {lte} (less than or equal to), {ne} or {neq} (not equal to).",values:{eq:`\`"${k.a.EQ}"\``,gt:`\`"${k.a.GT}"\``,gte:`\`"${k.a.GTE}"\``,lt:`\`"${k.a.LT}"\``,lte:`\`"${k.a.LTE}"\``,ne:`\`"${k.a.NE}"\``,neq:`\`"${k.a.NEQ}"\``}}),to:t.i18n.translate("xpack.canvas.functions.compare.args.toHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},b={invalidCompareOperator:(e,a)=>new Error(t.i18n.translate("xpack.canvas.functions.compare.invalidCompareOperatorErrorMessage",{defaultMessage:"Invalid compare operator: '{op}'. Use {ops}",values:{op:e,ops:a}}))},w={help:t.i18n.translate("xpack.canvas.functions.containerStyleHelpText",{defaultMessage:"Creates an object used for styling an element's container, including background, border, and opacity."}),args:{backgroundColor:t.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundColorHelpText",{defaultMessage:"A valid {CSS} background color.",values:{CSS:n.e}}),backgroundImage:t.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundImageHelpText",{defaultMessage:"A valid {CSS} background image.",values:{CSS:n.e}}),backgroundRepeat:t.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundRepeatHelpText",{defaultMessage:"A valid {CSS} background repeat.",values:{CSS:n.e}}),backgroundSize:t.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundSizeHelpText",{defaultMessage:"A valid {CSS} background size.",values:{CSS:n.e}}),border:t.i18n.translate("xpack.canvas.functions.containerStyle.args.borderHelpText",{defaultMessage:"A valid {CSS} border.",values:{CSS:n.e}}),borderRadius:t.i18n.translate("xpack.canvas.functions.containerStyle.args.borderRadiusHelpText",{defaultMessage:"The number of pixels to use when rounding the corners."}),opacity:t.i18n.translate("xpack.canvas.functions.containerStyle.args.opacityHelpText",{defaultMessage:"A number between 0 and 1 that represents the degree of transparency of the element."}),overflow:t.i18n.translate("xpack.canvas.functions.containerStyle.args.overflowHelpText",{defaultMessage:"A valid {CSS} overflow.",values:{CSS:n.e}}),padding:t.i18n.translate("xpack.canvas.functions.containerStyle.args.paddingHelpText",{defaultMessage:"The distance of the content, in pixels, from the border."})}},S={invalidBackgroundImage:()=>new Error(t.i18n.translate("xpack.canvas.functions.containerStyle.invalidBackgroundImageErrorMessage",{defaultMessage:"Invalid backgroundImage. Please provide an asset or a URL."}))},L={help:t.i18n.translate("xpack.canvas.functions.contextHelpText",{defaultMessage:"Returns whatever you pass into it. This can be useful when you need to use {CONTEXT} as argument to a function as a sub-expression.",values:{CONTEXT:n.d}}),args:{}},H={help:t.i18n.translate("xpack.canvas.functions.csvHelpText",{defaultMessage:"Creates a {DATATABLE} from {CSV} input.",values:{DATATABLE:n.g,CSV:n.f}}),args:{data:t.i18n.translate("xpack.canvas.functions.csv.args.dataHelpText",{defaultMessage:"The {CSV} data to use.",values:{CSV:n.f}}),delimiter:t.i18n.translate("xpack.canvas.functions.csv.args.delimeterHelpText",{defaultMessage:"The data separation character."}),newline:t.i18n.translate("xpack.canvas.functions.csv.args.newlineHelpText",{defaultMessage:"The row separation character."})}},D={invalidInputCSV:()=>new Error(t.i18n.translate("xpack.canvas.functions.csv.invalidInputCSVErrorMessage",{defaultMessage:"Error parsing input CSV."}))},N={help:t.i18n.translate("xpack.canvas.functions.dateHelpText",{defaultMessage:"Returns the current time, or a time parsed from a specified string, as milliseconds since epoch."}),args:{value:t.i18n.translate("xpack.canvas.functions.date.args.valueHelpText",{defaultMessage:"An optional date string that is parsed into milliseconds since epoch. The date string can be either a valid {JS} {date} input or a string to parse using the {formatArg} argument. Must be an {ISO8601} string, or you must provide the format.",values:{JS:n.q,date:"`Date`",formatArg:"`format`",ISO8601:n.p}}),format:t.i18n.translate("xpack.canvas.functions.date.args.formatHelpText",{defaultMessage:"The {MOMENTJS} format used to parse the specified date string. For more information, see {url}.",values:{MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}})}},E={invalidDateInput:e=>new Error(t.i18n.translate("xpack.canvas.functions.date.invalidDateInputErrorMessage",{defaultMessage:"Invalid date input: {date}",values:{date:e}}))};let C;!function(e){e.CI="ci",e.SHIRTS="shirts"}(C||(C={}));const A={help:t.i18n.translate("xpack.canvas.functions.demodataHelpText",{defaultMessage:"A sample data set that includes project {ci} times with usernames, countries, and run phases.",values:{ci:"CI"}}),args:{type:t.i18n.translate("xpack.canvas.functions.demodata.args.typeHelpText",{defaultMessage:"The name of the demo data set to use."})}},F={invalidDataSet:e=>new Error(t.i18n.translate("xpack.canvas.functions.demodata.invalidDataSetErrorMessage",{defaultMessage:"Invalid data set: '{arg}', use '{ci}' or '{shirts}'.",values:{arg:e,ci:C.CI,shirts:C.SHIRTS}}))},O={help:t.i18n.translate("xpack.canvas.functions.doHelpText",{defaultMessage:"Executes multiple sub-expressions, then returns the original {CONTEXT}. Use for running functions that produce an action or a side effect without changing the original {CONTEXT}.",values:{CONTEXT:n.d}}),args:{fn:t.i18n.translate("xpack.canvas.functions.do.args.fnHelpText",{defaultMessage:"The sub-expressions to execute. The return values of these sub-expressions are not available in the root pipeline as this function simply returns the original {CONTEXT}.",values:{CONTEXT:n.d}})}},I={help:t.i18n.translate("xpack.canvas.functions.dropdownControlHelpText",{defaultMessage:"Configures a dropdown filter control element."}),args:{filterColumn:t.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterColumnHelpText",{defaultMessage:"The column or field that you want to filter."}),labelColumn:t.i18n.translate("xpack.canvas.functions.dropdownControl.args.labelColumnHelpText",{defaultMessage:"The column or field to use as the label in the dropdown control"}),valueColumn:t.i18n.translate("xpack.canvas.functions.dropdownControl.args.valueColumnHelpText",{defaultMessage:"The column or field from which to extract the unique values for the dropdown control."}),filterGroup:t.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},R={help:t.i18n.translate("xpack.canvas.functions.eqHelpText",{defaultMessage:"Returns whether the {CONTEXT} is equal to the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.eq.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},B={help:t.i18n.translate("xpack.canvas.functions.embeddableHelpText",{defaultMessage:"Returns an embeddable with the provided configuration"}),args:{config:t.i18n.translate("xpack.canvas.functions.embeddable.args.idHelpText",{defaultMessage:"The base64 encoded embeddable input object"}),type:t.i18n.translate("xpack.canvas.functions.embeddable.args.typeHelpText",{defaultMessage:"The embeddable type"})}},V={help:t.i18n.translate("xpack.canvas.functions.escountHelpText",{defaultMessage:"Query {ELASTICSEARCH} for the number of hits matching the specified query.",values:{ELASTICSEARCH:n.i}}),args:{query:t.i18n.translate("xpack.canvas.functions.escount.args.queryHelpText",{defaultMessage:"A {LUCENE} query string.",values:{LUCENE:n.s}}),index:t.i18n.translate("xpack.canvas.functions.escount.args.indexHelpText",{defaultMessage:"An index or data view. For example, {example}.",values:{example:'`"logstash-*"`'}})}},P={help:t.i18n.translate("xpack.canvas.functions.esdocsHelpText",{defaultMessage:"Query {ELASTICSEARCH} for raw documents. Specify the fields you want to retrieve, especially if you are asking for a lot of rows.",values:{ELASTICSEARCH:n.i}}),args:{query:t.i18n.translate("xpack.canvas.functions.esdocs.args.queryHelpText",{defaultMessage:"A {LUCENE} query string.",values:{LUCENE:n.s}}),count:t.i18n.translate("xpack.canvas.functions.esdocs.args.countHelpText",{defaultMessage:"The number of documents to retrieve. For better performance, use a smaller data set."}),fields:t.i18n.translate("xpack.canvas.functions.esdocs.args.fieldsHelpText",{defaultMessage:"A comma-separated list of fields. For better performance, use fewer fields."}),index:t.i18n.translate("xpack.canvas.functions.esdocs.args.indexHelpText",{defaultMessage:"An index or data view. For example, {example}.",values:{example:'`"logstash-*"`'}}),metaFields:t.i18n.translate("xpack.canvas.functions.esdocs.args.metaFieldsHelpText",{defaultMessage:"Comma separated list of meta fields. For example, {example}.",values:{example:'`"_index,_type"`'}}),sort:t.i18n.translate("xpack.canvas.functions.esdocs.args.sortHelpText",{defaultMessage:"The sort direction formatted as {directions}. For example, {example1} or {example2}.",values:{directions:`\`"${["field","direction"].join(", ")}"\``,example1:`\`"${["@timestamp","desc"].join(", ")}"\``,example2:`\`"${["bytes","asc"].join(", ")}"\``}})}},_={help:t.i18n.translate("xpack.canvas.functions.exactlyHelpText",{defaultMessage:"Creates a filter that matches a given column to an exact value."}),args:{column:t.i18n.translate("xpack.canvas.functions.exactly.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),value:t.i18n.translate("xpack.canvas.functions.exactly.args.valueHelpText",{defaultMessage:"The value to match exactly, including white space and capitalization."}),filterGroup:t.i18n.translate("xpack.canvas.functions.exactly.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},U={help:t.i18n.translate("xpack.canvas.functions.filterrowsHelpText",{defaultMessage:"Filters rows in a {DATATABLE} based on the return value of a sub-expression.",values:{DATATABLE:n.g}}),args:{fn:t.i18n.translate("xpack.canvas.functions.filterrows.args.fnHelpText",{defaultMessage:"An expression to pass into each row in the {DATATABLE}. The expression should return a {TYPE_BOOLEAN}. A {BOOLEAN_TRUE} value preserves the row, and a {BOOLEAN_FALSE} value removes it.",values:{BOOLEAN_FALSE:n.a,BOOLEAN_TRUE:n.b,DATATABLE:n.g,TYPE_BOOLEAN:n.G}})}},z={help:t.i18n.translate("xpack.canvas.functions.filtersHelpText",{defaultMessage:"Aggregates element filters from the workpad for use elsewhere, usually a data source. {FILTER_FN} is deprecated and will be removed in a future release. Use {REPLACEMENT} instead.",values:{FILTER_FN:"`filters`",REPLACEMENT:"`kibana | selectFilter`"}}),args:{group:t.i18n.translate("xpack.canvas.functions.filters.args.group",{defaultMessage:"The name of the filter group to use."}),ungrouped:t.i18n.translate("xpack.canvas.functions.filters.args.ungrouped",{defaultMessage:"Exclude filters that belong to a filter group?"})}},G={help:t.i18n.translate("xpack.canvas.functions.formatdateHelpText",{defaultMessage:"Formats an {ISO8601} date string or a date in milliseconds since epoch using {MOMENTJS}. See {url}.",values:{ISO8601:n.p,MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}}),args:{format:t.i18n.translate("xpack.canvas.functions.formatdate.args.formatHelpText",{defaultMessage:"A {MOMENTJS} format. For example, {example}. See {url}.",values:{MOMENTJS:n.v,example:'`"MM/DD/YYYY"`',url:"https://momentjs.com/docs/#/displaying/"}})}},q={help:t.i18n.translate("xpack.canvas.functions.formatnumberHelpText",{defaultMessage:"Formats a number into a formatted number string using the {NUMERALJS}.",values:{NUMERALJS:n.x}}),args:{format:t.i18n.translate("xpack.canvas.functions.formatnumber.args.formatHelpText",{defaultMessage:"A {NUMERALJS} format string. For example, {example1} or {example2}.",values:{example1:'`"0.0a"`',example2:'`"0%"`',NUMERALJS:n.x}})}},X={help:t.i18n.translate("xpack.canvas.functions.getCellHelpText",{defaultMessage:"Fetches a single cell from a {DATATABLE}.",values:{DATATABLE:n.g}}),args:{column:t.i18n.translate("xpack.canvas.functions.getCell.args.columnHelpText",{defaultMessage:"The name of the column to fetch the value from. If not provided, the value is retrieved from the first column."}),row:t.i18n.translate("xpack.canvas.functions.getCell.args.rowHelpText",{defaultMessage:"The row number, starting at 0."})}},W={rowNotFound:e=>new Error(t.i18n.translate("xpack.canvas.functions.getCell.rowNotFoundErrorMessage",{defaultMessage:"Row not found: '{row}'",values:{row:e}})),columnNotFound:e=>new Error(t.i18n.translate("xpack.canvas.functions.getCell.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}}))},Y={help:t.i18n.translate("xpack.canvas.functions.gtHelpText",{defaultMessage:"Returns whether the {CONTEXT} is greater than the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.gt.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},j={help:t.i18n.translate("xpack.canvas.functions.gteHelpText",{defaultMessage:"Returns whether the {CONTEXT} is greater or equal to the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.gte.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},J={help:t.i18n.translate("xpack.canvas.functions.headHelpText",{defaultMessage:"Retrieves the first {n} rows from the {DATATABLE}. See also {tailFn}.",values:{n:"N",DATATABLE:n.g,tailFn:"`tail`"}}),args:{count:t.i18n.translate("xpack.canvas.functions.head.args.countHelpText",{defaultMessage:"The number of rows to retrieve from the beginning of the {DATATABLE}.",values:{DATATABLE:n.g}})}},Q={help:t.i18n.translate("xpack.canvas.functions.ifHelpText",{defaultMessage:"Performs conditional logic."}),args:{condition:t.i18n.translate("xpack.canvas.functions.if.args.conditionHelpText",{defaultMessage:"A {BOOLEAN_TRUE} or {BOOLEAN_FALSE} indicating whether a condition is met, usually returned by a sub-expression. When unspecified, the original {CONTEXT} is returned.",values:{BOOLEAN_TRUE:n.b,BOOLEAN_FALSE:n.a,CONTEXT:n.d}}),then:t.i18n.translate("xpack.canvas.functions.if.args.thenHelpText",{defaultMessage:"The return value when the condition is {BOOLEAN_TRUE}. When unspecified and the condition is met, the original {CONTEXT} is returned.",values:{BOOLEAN_TRUE:n.b,CONTEXT:n.d}}),else:t.i18n.translate("xpack.canvas.functions.if.args.elseHelpText",{defaultMessage:"The return value when the condition is {BOOLEAN_FALSE}. When unspecified and the condition is not met, the original {CONTEXT} is returned.",values:{BOOLEAN_FALSE:n.a,CONTEXT:n.d}})}},$={help:t.i18n.translate("xpack.canvas.functions.joinRowsHelpText",{defaultMessage:"Concatenates values from rows in a `datatable` into a single string."}),args:{column:t.i18n.translate("xpack.canvas.functions.joinRows.args.columnHelpText",{defaultMessage:"The column or field from which to extract the values."}),separator:t.i18n.translate("xpack.canvas.functions.joinRows.args.separatorHelpText",{defaultMessage:"The delimiter to insert between each extracted value."}),quote:t.i18n.translate("xpack.canvas.functions.joinRows.args.quoteHelpText",{defaultMessage:"The quote character to wrap around each extracted value."}),distinct:t.i18n.translate("xpack.canvas.functions.joinRows.args.distinctHelpText",{defaultMessage:"Extract only unique values?"})}},K={columnNotFound:e=>new Error(t.i18n.translate("xpack.canvas.functions.joinRows.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}}))},Z={help:t.i18n.translate("xpack.canvas.functions.locationHelpText",{defaultMessage:"Find your current location using the {geolocationAPI} of the browser. Performance can vary, but is fairly accurate. See {url}. Don’t use {locationFn} if you plan to generate PDFs as this function requires user input.",values:{geolocationAPI:"Geolocation API",url:"https://developer.mozilla.org/en-US/docs/Web/API/Navigator/geolocation",locationFn:"`location`"}}),args:{}},ee={help:t.i18n.translate("xpack.canvas.functions.ltHelpText",{defaultMessage:"Returns whether the {CONTEXT} is less than the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.lt.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},ae={help:t.i18n.translate("xpack.canvas.functions.lteHelpText",{defaultMessage:"Returns whether the {CONTEXT} is less than or equal to the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.lte.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},se={help:t.i18n.translate("xpack.canvas.functions.mapCenterHelpText",{defaultMessage:"Returns an object with the center coordinates and zoom level of the map."}),args:{lat:t.i18n.translate("xpack.canvas.functions.mapCenter.args.latHelpText",{defaultMessage:"Latitude for the center of the map"}),lon:t.i18n.translate("xpack.canvas.functions.savedMap.args.lonHelpText",{defaultMessage:"Longitude for the center of the map"}),zoom:t.i18n.translate("xpack.canvas.functions.savedMap.args.zoomHelpText",{defaultMessage:"Zoom level of the map"})}},te={help:t.i18n.translate("xpack.canvas.functions.markdownHelpText",{defaultMessage:"Adds an element that renders {MARKDOWN} text. TIP: Use the {markdownFn} function for single numbers, metrics, and paragraphs of text.",values:{MARKDOWN:n.u,markdownFn:"`markdown`"}}),args:{content:t.i18n.translate("xpack.canvas.functions.markdown.args.contentHelpText",{defaultMessage:"A string of text that contains {MARKDOWN}. To concatenate, pass the {stringFn} function multiple times.",values:{MARKDOWN:n.u,stringFn:"`string`"}}),font:t.i18n.translate("xpack.canvas.functions.markdown.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the content. For example, {fontFamily} or {fontWeight}.",values:{CSS:n.e,fontFamily:'"font-family"',fontWeight:'"font-weight"'}}),openLinksInNewTab:t.i18n.translate("xpack.canvas.functions.markdown.args.openLinkHelpText",{defaultMessage:"A true or false value for opening links in a new tab. The default value is `false`. Setting to `true` opens all links in a new tab."})}},ne={help:t.i18n.translate("xpack.canvas.functions.neqHelpText",{defaultMessage:"Returns whether the {CONTEXT} is not equal to the argument.",values:{CONTEXT:n.d}}),args:{value:t.i18n.translate("xpack.canvas.functions.neq.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},le={help:t.i18n.translate("xpack.canvas.functions.pieHelpText",{defaultMessage:"Configures a pie chart element."}),args:{font:t.i18n.translate("xpack.canvas.functions.pie.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the labels. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),hole:t.i18n.translate("xpack.canvas.functions.pie.args.holeHelpText",{defaultMessage:"Draws a hole in the pie, between `0` and `100`, as a percentage of the pie radius."}),labelRadius:t.i18n.translate("xpack.canvas.functions.pie.args.labelRadiusHelpText",{defaultMessage:"The percentage of the container area to use as a radius for the label circle."}),labels:t.i18n.translate("xpack.canvas.functions.pie.args.labelsHelpText",{defaultMessage:"Display the pie labels?"}),legend:t.i18n.translate("xpack.canvas.functions.pie.args.legendHelpText",{defaultMessage:"The legend position. For example, {legend}, or {BOOLEAN_FALSE}. When {BOOLEAN_FALSE}, the legend is hidden.",values:{legend:Object.values(d.Legend).map((e=>`\`"${e}"\``)).join(", "),BOOLEAN_FALSE:n.a}}),palette:t.i18n.translate("xpack.canvas.functions.pie.args.paletteHelpText",{defaultMessage:"A {palette} object for describing the colors to use in this pie chart.",values:{palette:"`palette`"}}),radius:t.i18n.translate("xpack.canvas.functions.pie.args.radiusHelpText",{defaultMessage:"The radius of the pie as a percentage, between `0` and `1`, of the available space. To automatically set the radius, use {auto}.",values:{auto:'`"auto"`'}}),seriesStyle:t.i18n.translate("xpack.canvas.functions.pie.args.seriesStyleHelpText",{defaultMessage:"A style of a specific series"}),tilt:t.i18n.translate("xpack.canvas.functions.pie.args.tiltHelpText",{defaultMessage:"The percentage of tilt where `1` is fully vertical, and `0` is completely flat."})}},ie={help:t.i18n.translate("xpack.canvas.functions.plotHelpText",{defaultMessage:"Configures a chart element."}),args:{defaultStyle:t.i18n.translate("xpack.canvas.functions.plot.args.defaultStyleHelpText",{defaultMessage:"The default style to use for every series."}),font:t.i18n.translate("xpack.canvas.functions.plot.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the labels. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),legend:t.i18n.translate("xpack.canvas.functions.plot.args.legendHelpText",{defaultMessage:"The legend position. For example, {legend}, or {BOOLEAN_FALSE}. When {BOOLEAN_FALSE}, the legend is hidden.",values:{legend:Object.values(d.Legend).map((e=>`\`"${e}"\``)).join(", "),BOOLEAN_FALSE:n.a}}),palette:t.i18n.translate("xpack.canvas.functions.plot.args.paletteHelpText",{defaultMessage:"A {palette} object for describing the colors to use in this chart.",values:{palette:"`palette`"}}),seriesStyle:t.i18n.translate("xpack.canvas.functions.plot.args.seriesStyleHelpText",{defaultMessage:"A style of a specific series"}),xaxis:t.i18n.translate("xpack.canvas.functions.plot.args.xaxisHelpText",{defaultMessage:"The axis configuration. When {BOOLEAN_FALSE}, the axis is hidden.",values:{BOOLEAN_FALSE:n.a}}),yaxis:t.i18n.translate("xpack.canvas.functions.plot.args.yaxisHelpText",{defaultMessage:"The axis configuration. When {BOOLEAN_FALSE}, the axis is hidden.",values:{BOOLEAN_FALSE:n.a}})}},re={help:t.i18n.translate("xpack.canvas.functions.plyHelpText",{defaultMessage:"Subdivides a {DATATABLE} by the unique values of the specified columns, and passes the resulting tables into an expression, then merges the outputs of each expression.",values:{DATATABLE:n.g}}),args:{by:t.i18n.translate("xpack.canvas.functions.ply.args.byHelpText",{defaultMessage:"The column to subdivide the {DATATABLE}.",values:{DATATABLE:n.g}}),expression:t.i18n.translate("xpack.canvas.functions.ply.args.expressionHelpText",{defaultMessage:"An expression to pass each resulting {DATATABLE} into. Tips: Expressions must return a {DATATABLE}. Use {asFn} to turn literals into {DATATABLE}s. Multiple expressions must return the same number of rows.If you need to return a different row count, pipe into another instance of {plyFn}. If multiple expressions returns the columns with the same name, the last one wins.",values:{asFn:"`as`",DATATABLE:n.g,plyFn:"`ply`"}})}},oe={columnNotFound:e=>new Error(t.i18n.translate("xpack.canvas.functions.ply.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{by}'",values:{by:e}})),rowCountMismatch:()=>new Error(t.i18n.translate("xpack.canvas.functions.ply.rowCountMismatchErrorMessage",{defaultMessage:"All expressions must return the same number of rows"}))},ce={help:t.i18n.translate("xpack.canvas.functions.pointseriesHelpText",{defaultMessage:"Turn a {DATATABLE} into a point series model. Currently we differentiate measure from dimensions by looking for a {TINYMATH} expression. See {TINYMATH_URL}. If you enter a {TINYMATH} expression in your argument, we treat that argument as a measure, otherwise it is a dimension. Dimensions are combined to create unique keys. Measures are then deduplicated by those keys using the specified {TINYMATH} function",values:{DATATABLE:n.g,TINYMATH:n.E,TINYMATH_URL:n.F}}),args:{color:t.i18n.translate("xpack.canvas.functions.pointseries.args.colorHelpText",{defaultMessage:"An expression to use in determining the mark's color."}),size:t.i18n.translate("xpack.canvas.functions.pointseries.args.sizeHelpText",{defaultMessage:"The size of the marks. Only applicable to supported elements."}),text:t.i18n.translate("xpack.canvas.functions.pointseries.args.textHelpText",{defaultMessage:"The text to show on the mark. Only applicable to supported elements."}),x:t.i18n.translate("xpack.canvas.functions.pointseries.args.xHelpText",{defaultMessage:"The values along the X-axis."}),y:t.i18n.translate("xpack.canvas.functions.pointseries.args.yHelpText",{defaultMessage:"The values along the Y-axis."})}},ue={unwrappedExpression:()=>new Error(t.i18n.translate("xpack.canvas.functions.pointseries.unwrappedExpressionErrorMessage",{defaultMessage:"Expressions must be wrapped in a function such as {fn}",values:{fn:"sum()"}}))},pe={help:t.i18n.translate("xpack.canvas.functions.renderHelpText",{defaultMessage:"Renders the {CONTEXT} as a specific element and sets element level options, such as background and border styling.",values:{CONTEXT:n.d}}),args:{as:t.i18n.translate("xpack.canvas.functions.render.args.asHelpText",{defaultMessage:"The element type to render. You probably want a specialized function instead, such as {plotFn} or {shapeFn}.",values:{plotFn:"`plot`",shapeFn:"`shape`"}}),css:t.i18n.translate("xpack.canvas.functions.render.args.cssHelpText",{defaultMessage:"Any block of custom {CSS} to be scoped to the element.",values:{CSS:n.e}}),containerStyle:t.i18n.translate("xpack.canvas.functions.render.args.containerStyleHelpText",{defaultMessage:"The style for the container, including background, border, and opacity."})}},ge={help:t.i18n.translate("xpack.canvas.functions.replaceImageHelpText",{defaultMessage:"Uses a regular expression to replace parts of a string."}),args:{pattern:t.i18n.translate("xpack.canvas.functions.replace.args.patternHelpText",{defaultMessage:"The text or pattern of a {JS} regular expression. For example, {example}. You can use capturing groups here.",values:{JS:n.q,example:'`"[aeiou]"`'}}),flags:t.i18n.translate("xpack.canvas.functions.replace.args.flagsHelpText",{defaultMessage:"Specify flags. See {url}.",values:{url:"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp"}}),replacement:t.i18n.translate("xpack.canvas.functions.replace.args.replacementHelpText",{defaultMessage:"The replacement for the matching parts of string. Capturing groups can be accessed by their index. For example, {example}.",values:{example:'`"$1"`'}})}},de={help:t.i18n.translate("xpack.canvas.functions.rounddateHelpText",{defaultMessage:"Uses a {MOMENTJS} formatting string to round milliseconds since epoch, and returns milliseconds since epoch.",values:{MOMENTJS:n.v}}),args:{format:t.i18n.translate("xpack.canvas.functions.rounddate.args.formatHelpText",{defaultMessage:"The {MOMENTJS} format to use for bucketing. For example, {example} rounds to months. See {url}.",values:{example:'`"YYYY-MM"`',MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}})}},fe={help:t.i18n.translate("xpack.canvas.functions.rowCountHelpText",{defaultMessage:"Returns the number of rows. Pairs with {plyFn} to get the count of unique column values, or combinations of unique column values.",values:{plyFn:"`ply`"}}),args:{}},me={help:t.i18n.translate("xpack.canvas.functions.savedLensHelpText",{defaultMessage:"Returns an embeddable for a saved Lens visualization object."}),args:{id:t.i18n.translate("xpack.canvas.functions.savedLens.args.idHelpText",{defaultMessage:"The ID of the saved Lens visualization object"}),timerange:t.i18n.translate("xpack.canvas.functions.savedLens.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),title:t.i18n.translate("xpack.canvas.functions.savedLens.args.titleHelpText",{defaultMessage:"The title for the Lens visualization object"}),palette:t.i18n.translate("xpack.canvas.functions.savedLens.args.paletteHelpText",{defaultMessage:"The palette used for the Lens visualization"})}},ve={help:t.i18n.translate("xpack.canvas.functions.savedMapHelpText",{defaultMessage:"Returns an embeddable for a saved map object."}),args:{id:t.i18n.translate("xpack.canvas.functions.savedMap.args.idHelpText",{defaultMessage:"The ID of the saved map object"}),center:t.i18n.translate("xpack.canvas.functions.savedMap.args.centerHelpText",{defaultMessage:"The center and zoom level the map should have"}),hideLayer:t.i18n.translate("xpack.canvas.functions.savedMap.args.hideLayer",{defaultMessage:"The IDs of map layers that should be hidden"}),timerange:t.i18n.translate("xpack.canvas.functions.savedMap.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),title:t.i18n.translate("xpack.canvas.functions.savedMap.args.titleHelpText",{defaultMessage:"The title for the map"})}},xe={help:t.i18n.translate("xpack.canvas.functions.savedSearchHelpText",{defaultMessage:"Returns an embeddable for a saved search object"}),args:{id:"The id of the saved search object"}},he={help:t.i18n.translate("xpack.canvas.functions.savedVisualizationHelpText",{defaultMessage:"Returns an embeddable for a saved visualization object."}),args:{id:t.i18n.translate("xpack.canvas.functions.savedVisualization.args.idHelpText",{defaultMessage:"The ID of the saved visualization object"}),timerange:t.i18n.translate("xpack.canvas.functions.savedVisualization.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),colors:t.i18n.translate("xpack.canvas.functions.savedVisualization.args.colorsHelpText",{defaultMessage:"Defines the color to use for a specific series"}),hideLegend:t.i18n.translate("xpack.canvas.functions.savedVisualization.args.hideLegendHelpText",{defaultMessage:"Specifies the option to hide the legend"}),title:t.i18n.translate("xpack.canvas.functions.savedVisualization.args.titleHelpText",{defaultMessage:"The title for the visualization object"})}},Te={help:t.i18n.translate("xpack.canvas.functions.seriesStyleHelpText",{defaultMessage:"Creates an object used for describing the properties of a series on a chart. Use {seriesStyleFn} inside of a charting function, like {plotFn} or {pieFn}.",values:{seriesStyleFn:"`seriesStyle`",pieFn:"`pie`",plotFn:"`plot`"}}),args:{bars:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.barsHelpText",{defaultMessage:"The width of bars."}),color:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.colorHelpText",{defaultMessage:"The line color."}),fill:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.fillHelpText",{defaultMessage:"Should we fill in the points?"}),horizontalBars:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.horizontalBarsHelpText",{defaultMessage:"Sets the orientation of the bars in the chart to horizontal."}),label:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.labelHelpText",{defaultMessage:"The name of the series to style."}),lines:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.linesHelpText",{defaultMessage:"The width of the line."}),points:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.pointsHelpText",{defaultMessage:"The size of points on line."}),stack:t.i18n.translate("xpack.canvas.functions.seriesStyle.args.stackHelpText",{defaultMessage:"Specifies if the series should be stacked. The number is the stack ID. Series with the same stack ID are stacked together."})}},Me={help:t.i18n.translate("xpack.canvas.functions.sortHelpText",{defaultMessage:"Sorts a {DATATABLE} by the specified column.",values:{DATATABLE:n.g}}),args:{by:t.i18n.translate("xpack.canvas.functions.sort.args.byHelpText",{defaultMessage:"The column to sort by. When unspecified, the {DATATABLE} is sorted by the first column.",values:{DATATABLE:n.g}}),reverse:t.i18n.translate("xpack.canvas.functions.sort.args.reverseHelpText",{defaultMessage:"Reverses the sorting order. When unspecified, the {DATATABLE} is sorted in ascending order.",values:{DATATABLE:n.g}})}},ke={help:t.i18n.translate("xpack.canvas.functions.staticColumnHelpText",{defaultMessage:"Adds a column with the same static value in every row. See also {alterColumnFn}, {mapColumnFn}, and {mathColumnFn}",values:{alterColumnFn:"`alterColumn`",mapColumnFn:"`mapColumn`",mathColumnFn:"`mathColumn`"}}),args:{name:t.i18n.translate("xpack.canvas.functions.staticColumn.args.nameHelpText",{defaultMessage:"The name of the new column."}),value:t.i18n.translate("xpack.canvas.functions.staticColumn.args.valueHelpText",{defaultMessage:"The value to insert in each row in the new column. TIP: use a sub-expression to rollup other columns into a static value."})}},ye={help:t.i18n.translate("xpack.canvas.functions.stringHelpText",{defaultMessage:"Concatenates all of the arguments into a single string."}),args:{value:t.i18n.translate("xpack.canvas.functions.string.args.valueHelpText",{defaultMessage:"The values to join together into one string. Include spaces where needed."})}},be={help:t.i18n.translate("xpack.canvas.functions.switchHelpText",{defaultMessage:"Performs conditional logic with multiple conditions. See also {caseFn}, which builds a {case} to pass to the {switchFn} function.",values:{case:"`case`",caseFn:"`case`",switchFn:"`switch`"}}),args:{case:t.i18n.translate("xpack.canvas.functions.switch.args.caseHelpText",{defaultMessage:"The conditions to check."}),default:t.i18n.translate("xpack.canvas.functions.switch.args.defaultHelpText",{defaultMessage:"The value returned when no conditions are met. When unspecified and no conditions are met, the original {CONTEXT} is returned.",values:{CONTEXT:n.d}})}},we={help:t.i18n.translate("xpack.canvas.functions.tableHelpText",{defaultMessage:"Configures a table element."}),args:{font:t.i18n.translate("xpack.canvas.functions.table.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the contents of the table. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),paginate:t.i18n.translate("xpack.canvas.functions.table.args.paginateHelpText",{defaultMessage:"Show pagination controls? When {BOOLEAN_FALSE}, only the first page is displayed.",values:{BOOLEAN_FALSE:n.a}}),perPage:t.i18n.translate("xpack.canvas.functions.table.args.perPageHelpText",{defaultMessage:"The number of rows to display on each page."}),showHeader:t.i18n.translate("xpack.canvas.functions.table.args.showHeaderHelpText",{defaultMessage:"Show or hide the header row with titles for each column."})}},Se={help:t.i18n.translate("xpack.canvas.functions.tailHelpText",{defaultMessage:"Retrieves the last N rows from the end of a {DATATABLE}. See also {headFn}.",values:{DATATABLE:n.g,headFn:"`head`"}}),args:{count:t.i18n.translate("xpack.canvas.functions.tail.args.countHelpText",{defaultMessage:"The number of rows to retrieve from the end of the {DATATABLE}.",values:{DATATABLE:n.g}})}},Le={help:t.i18n.translate("xpack.canvas.functions.timefilterHelpText",{defaultMessage:"Creates a time filter for querying a source."}),args:{column:t.i18n.translate("xpack.canvas.functions.timefilter.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),from:t.i18n.translate("xpack.canvas.functions.timefilter.args.fromHelpText",{defaultMessage:"The beginning of the range, in {ISO8601} or {ELASTICSEARCH} {DATEMATH} format",values:{DATEMATH:n.h,ELASTICSEARCH:n.i,ISO8601:n.p}}),to:t.i18n.translate("xpack.canvas.functions.timefilter.args.toHelpText",{defaultMessage:"The end of the range, in {ISO8601} or {ELASTICSEARCH} {DATEMATH} format",values:{DATEMATH:n.h,ELASTICSEARCH:n.i,ISO8601:n.p}}),filterGroup:t.i18n.translate("xpack.canvas.functions.timefilter.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},He={invalidString:e=>new Error(t.i18n.translate("xpack.canvas.functions.timefilter.invalidStringErrorMessage",{defaultMessage:"Invalid date/time string: '{str}'",values:{str:e}}))},De={help:t.i18n.translate("xpack.canvas.functions.timefilterControlHelpText",{defaultMessage:"Configures a time filter control element."}),args:{column:t.i18n.translate("xpack.canvas.functions.timefilterControl.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),compact:t.i18n.translate("xpack.canvas.functions.timefilterControl.args.compactHelpText",{defaultMessage:"Shows the time filter as a button, which triggers a popover."}),filterGroup:t.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},Ne={help:t.i18n.translate("xpack.canvas.functions.timelionHelpText",{defaultMessage:"Uses Timelion to extract one or more time series from many sources."}),args:{query:t.i18n.translate("xpack.canvas.functions.timelion.args.query",{defaultMessage:"A Timelion query"}),interval:t.i18n.translate("xpack.canvas.functions.timelion.args.interval",{defaultMessage:"The bucket interval for the time series."}),from:t.i18n.translate("xpack.canvas.functions.timelion.args.from",{defaultMessage:"The {ELASTICSEARCH} {DATEMATH} string for the beginning of the time range.",values:{ELASTICSEARCH:n.i,DATEMATH:n.h}}),to:t.i18n.translate("xpack.canvas.functions.timelion.args.to",{defaultMessage:"The {ELASTICSEARCH} {DATEMATH} string for the end of the time range.",values:{ELASTICSEARCH:n.i,DATEMATH:n.h}}),timezone:t.i18n.translate("xpack.canvas.functions.timelion.args.timezone",{defaultMessage:"The timezone for the time range. See {MOMENTJS_TIMEZONE_URL}.",values:{MOMENTJS_TIMEZONE_URL:n.w}})}},Ee={help:t.i18n.translate("xpack.canvas.functions.timerangeHelpText",{defaultMessage:"An object that represents a span of time."}),args:{from:t.i18n.translate("xpack.canvas.functions.timerange.args.fromHelpText",{defaultMessage:"The start of the time range"}),to:t.i18n.translate("xpack.canvas.functions.timerange.args.toHelpText",{defaultMessage:"The end of the time range"})}},Ce={help:t.i18n.translate("xpack.canvas.functions.toHelpText",{defaultMessage:"Explicitly casts the type of the {CONTEXT} from one type to the specified type.",values:{CONTEXT:n.d}}),args:{type:t.i18n.translate("xpack.canvas.functions.to.args.type",{defaultMessage:"A known data type in the expression language."})}},Ae={missingType:()=>new Error(t.i18n.translate("xpack.canvas.functions.to.missingType",{defaultMessage:"Must specify a casting type"}))},Fe={help:t.i18n.translate("xpack.canvas.functions.urlparamHelpText",{defaultMessage:"Retrieves a {URL} parameter to use in an expression. The {urlparamFn} function always returns a {TYPE_STRING}. For example, you can retrieve the value {value} from the parameter {myVar} from the {URL} {example}.",values:{example:"`https://localhost:5601/app/canvas?myVar=20`",myVar:"`myVar`",TYPE_STRING:n.J,URL:n.K,urlparamFn:"`urlparam`",value:'`"20"`'}}),args:{param:t.i18n.translate("xpack.canvas.functions.urlparam.args.paramHelpText",{defaultMessage:"The {URL} hash parameter to retrieve.",values:{URL:n.K}}),default:t.i18n.translate("xpack.canvas.functions.urlparam.args.defaultHelpText",{defaultMessage:"The string returned when the {URL} parameter is unspecified.",values:{URL:n.K}})}},Oe=()=>({all:l,alterColumn:r,any:c,as:u,asset:p,axisConfig:f,case:h,clear:T,columns:M,compare:y,containerStyle:w,context:L,csv:H,date:N,demodata:A,do:O,dropdownControl:I,eq:R,embeddable:B,escount:V,esdocs:P,exactly:_,filterrows:U,filters:z,formatdate:G,formatnumber:q,getCell:X,gt:Y,gte:j,head:J,if:Q,joinRows:$,location:Z,lt:ee,lte:ae,mapCenter:se,markdown:te,neq:ne,pie:le,plot:ie,ply:re,pointseries:ce,render:pe,replace:ge,rounddate:de,rowCount:fe,savedLens:me,savedMap:ve,savedSearch:xe,savedVisualization:he,seriesStyle:Te,sort:Me,staticColumn:ke,string:ye,switch:be,table:we,tail:Se,timefilter:Le,timefilterControl:De,timelion:Ne,timerange:Ee,to:Ce,urlparam:Fe}),Ie=()=>({alterColumn:o,asset:g,axisConfig:m,compare:b,containerStyle:S,csv:D,date:E,demodata:F,getCell:W,joinRows:K,ply:oe,pointseries:ue,timefilter:He,to:Ae})},126:function(e,a,s){"use strict";s.d(a,"a",(function(){return l})),s.d(a,"b",(function(){return i})),s.d(a,"c",(function(){return r})),s.d(a,"d",(function(){return o})),s.d(a,"e",(function(){return c}));var t=s(3),n=s(58);const l={AxisConfig:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfigTitle",{defaultMessage:"Axis config"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfigLabel",{defaultMessage:"Visualization axis configuration"}),getDisabledText:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfigDisabledText",{defaultMessage:"Switch on to view axis settings"}),getPositionBottom:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.bottomDropDown",{defaultMessage:"bottom"}),getPositionLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfig.positionLabel",{defaultMessage:"Position"}),getPositionLeft:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.leftDropDown",{defaultMessage:"left"}),getPositionRight:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.rightDropDown",{defaultMessage:"right"}),getPositionTop:()=>t.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.topDropDown",{defaultMessage:"top"})},DataColumn:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumnTitle",{defaultMessage:"Column"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumnLabel",{defaultMessage:"Select the data column"}),getOptionAverage:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.averageDropDown",{defaultMessage:"Average"}),getOptionCount:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.countDropDown",{defaultMessage:"Count"}),getOptionFirst:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.firstDropDown",{defaultMessage:"First"}),getOptionLast:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.lastDropDown",{defaultMessage:"Last"}),getOptionMax:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.maxDropDown",{defaultMessage:"Max"}),getOptionMedian:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.medianDropDown",{defaultMessage:"Median"}),getOptionMin:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.minDropDown",{defaultMessage:"Min"}),getOptionSum:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.sumDropDown",{defaultMessage:"Sum"}),getOptionUnique:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.uniqueDropDown",{defaultMessage:"Unique"}),getOptionValue:()=>t.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.valueDropDown",{defaultMessage:"Value"})},DateFormat:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.dateFormatTitle",{defaultMessage:"Date Format"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.dateFormatLabel",{defaultMessage:"Select or enter a {momentJS} format",values:{momentJS:n.v}})},FilterGroup:{getCreateNewGroup:()=>t.i18n.translate("xpack.canvas.uis.arguments.filterGroup.createNewGroupLinkText",{defaultMessage:"Create new group"}),getButtonSet:()=>t.i18n.translate("xpack.canvas.uis.arguments.filterGroup.setValue",{defaultMessage:"Set"}),getButtonCancel:()=>t.i18n.translate("xpack.canvas.uis.arguments.filterGroup.cancelValue",{defaultMessage:"Cancel"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.filterGroupTitle",{defaultMessage:"Filter Group"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.filterGroupLabel",{defaultMessage:"Create or select a filter group"})},ImageUpload:{getAssetUrlType:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.assetDropDown",{defaultMessage:"Asset"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUploadTitle",{defaultMessage:"Image upload"}),getFileUploadPrompt:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.fileUploadPromptLabel",{defaultMessage:"Select or drag and drop an image"}),getFileUrlType:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.fileDropDown",{defaultMessage:"Import"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUploadLabel",{defaultMessage:"Select or upload an image"}),getImageUploading:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.imageUploadingLabel",{defaultMessage:"Image uploading"}),getLinkUrlType:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.linkDropDown",{defaultMessage:"Link"}),getUrlFieldPlaceholder:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlFieldPlaceholder",{defaultMessage:"Image {url}",values:{url:n.K}}),getUrlTypeChangeLegend:()=>t.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.changeLegend",{defaultMessage:"Image upload type"})},Number:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberTitle",{defaultMessage:"Number"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberLabel",{defaultMessage:"Input a number"})},NumberFormat:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormatTitle",{defaultMessage:"Number Format"}),getFormatBytes:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.bytesDropDown",{defaultMessage:"Bytes"}),getFormatCurrency:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.currencyDropDown",{defaultMessage:"Currency"}),getFormatDuration:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.durationDropDown",{defaultMessage:"Duration"}),getFormatNumber:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.numberDropDown",{defaultMessage:"Number"}),getFormatPercent:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.percentDropDown",{defaultMessage:"Percent"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.numberFormatLabel",{defaultMessage:"Select or enter a valid {numeralJS} format",values:{numeralJS:n.x}})},Palette:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.paletteTitle",{defaultMessage:"Color palette"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.paletteLabel",{defaultMessage:"The collection of colors used to render the element"}),getCustomPaletteLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.customPaletteLabel",{defaultMessage:"Custom"})},PartitionLabels:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.partitionLabelsTitle",{defaultMessage:"Partition labels"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.partitionLabelsLabel",{defaultMessage:"Labels configuration"}),getPositionDefaultLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.positionDefaultLabel",{defaultMessage:"Default"}),getPositionInsideLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.positionInsideLabel",{defaultMessage:"Inside"}),getPositionLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.positionLabel",{defaultMessage:"Position"}),getValuesLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.valuesLabel",{defaultMessage:"Values"}),getValuesToggle:()=>t.i18n.translate("xpack.canvas.uis.arguments.valuesToggle",{defaultMessage:"Show values"}),getValuesFormatLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.valuesFormatLabel",{defaultMessage:"Values format"}),getValuesFormatValueLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.valuesFormatValueLabel",{defaultMessage:"Value"}),getValuesFormatPercentLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.valuesFormatPercentLabel",{defaultMessage:"Percent"}),getPercentDecimalsLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.percentDecimals",{defaultMessage:"Percent decimals"}),getSwitchedOffShowLabelsLabel:()=>t.i18n.translate("xpack.canvas.uis.arguments.turnedOffShowLabelsLabel",{defaultMessage:"Switch on to view labels settings"})},Color:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.colorTitle",{defaultMessage:"Color"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.colorLabel",{defaultMessage:"Color picker"})},Percentage:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.percentageTitle",{defaultMessage:"Percentage"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.percentageLabel",{defaultMessage:"Slider for percentage "})},Range:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.rangeTitle",{defaultMessage:"Range"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.rangeLabel",{defaultMessage:"Slider for values within a range"})},Select:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.selectTitle",{defaultMessage:"Select"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.selectLabel",{defaultMessage:"Select from multiple options in a drop down"})},Shape:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.shapeTitle",{defaultMessage:"Shape"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.shapeLabel",{defaultMessage:"Change the shape of the current element"})},String:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.stringTitle",{defaultMessage:"String"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.stringLabel",{defaultMessage:"Input short strings"})},Textarea:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.textareaTitle",{defaultMessage:"Textarea"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.textareaLabel",{defaultMessage:"Input long strings"})},Toggle:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.toggleTitle",{defaultMessage:"Toggle"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.toggleLabel",{defaultMessage:"A true/false toggle switch"})},VisDimension:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.visDimensionTitle",{defaultMessage:"Column"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.visDimensionLabel",{defaultMessage:"Generates visConfig dimension object"}),getDefaultOptionName:()=>t.i18n.translate("xpack.canvas.uis.arguments.visDimensionDefaultOptionName",{defaultMessage:"Select column"})},StopsPalette:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.stopsPaletteTitle",{defaultMessage:"Palette picker with bounds"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.stopsPaletteLabel",{defaultMessage:"Provides colors for the values, based on the bounds"})},Editor:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.arguments.editorTitle",{defaultMessage:"Editor"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.arguments.editorLabel",{defaultMessage:"Provides a text area with syntax highlighting"})}},i={DemoData:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.dataSources.demoDataTitle",{defaultMessage:"Demo data"}),getHeading:()=>t.i18n.translate("xpack.canvas.uis.dataSources.demoData.headingTitle",{defaultMessage:"This element is using demo data"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.dataSources.demoDataLabel",{defaultMessage:"Sample data set used to populate default elements"}),getDescription:()=>t.i18n.translate("xpack.canvas.uis.dataSources.demoDataDescription",{defaultMessage:"By default, every {canvas} element is connected to the demo data source. Change the data source, above, to connect your own data.",values:{canvas:n.c}})},ESDocs:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocsTitle",{defaultMessage:"{elasticsearch} documents",values:{elasticsearch:n.i}}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocsLabel",{defaultMessage:"Pull data directly from {elasticsearch} without the use of aggregations",values:{elasticsearch:n.i}}),getWarningTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.warningTitle",{defaultMessage:"Query with caution"}),getWarning:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.warningDescription",{defaultMessage:"\n        Using this data source with larger data sets can result in slower performance. Use this source only when you need exact values."}),getIndexTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.indexTitle",{defaultMessage:"Data view"}),getIndexLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.indexLabel",{defaultMessage:"Select a data view or enter an index name."}),getQueryTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.queryTitle",{defaultMessage:"Query"}),getQueryLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.queryLabel",{defaultMessage:"{lucene} query string syntax",values:{lucene:n.s}}),getSortFieldTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortFieldTitle",{defaultMessage:"Sort field"}),getSortFieldLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortFieldLabel",{defaultMessage:"Document sort field"}),getSortOrderTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortOrderTitle",{defaultMessage:"Sort order"}),getSortOrderLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortOrderLabel",{defaultMessage:"Document sort order"}),getFieldsTitle:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsTitle",{defaultMessage:"Fields"}),getFieldsLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsLabel",{defaultMessage:"Scripted fields are unavailable"}),getFieldsWarningLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsWarningLabel",{defaultMessage:"This datasource performs best with 10 or fewer fields"}),getAscendingOption:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.ascendingDropDown",{defaultMessage:"Ascending"}),getDescendingOption:()=>t.i18n.translate("xpack.canvas.uis.dataSources.esdocs.descendingDropDown",{defaultMessage:"Descending"})},Essql:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.dataSources.essqlTitle",{defaultMessage:"{elasticsearch} {sql}",values:{elasticsearch:n.i,sql:n.A}}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.dataSources.essqlLabel",{defaultMessage:"Write an {elasticsearch} {sql} query to retrieve data",values:{elasticsearch:n.i,sql:n.A}}),getLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.essql.queryTitle",{defaultMessage:"Query"}),getLabelAppend:()=>t.i18n.translate("xpack.canvas.uis.dataSources.essql.queryTitleAppend",{defaultMessage:"Learn {elasticsearchShort} {sql} query syntax",values:{elasticsearchShort:n.j,sql:n.A}})},Timelion:{getAbout:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.aboutDetail",{defaultMessage:"Use {timelion} syntax in {canvas} to retrieve timeseries data",values:{timelion:n.C,canvas:n.c}}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelionLabel",{defaultMessage:"Use {timelion} syntax to retrieve timeseries data",values:{timelion:n.C}}),getIntervalHelp:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.intervalLabel",{defaultMessage:"Use date math like {weeksExample}, {daysExample}, {secondsExample}, or {auto}",values:{secondsExample:"10s",daysExample:"5d",weeksExample:"1w",auto:"auto"}}),getIntervalLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.intervalTitle",{defaultMessage:"Interval"}),queryLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.queryLabel",{defaultMessage:"{timelion} Query String syntax",values:{timelion:n.C}}),getQueryLabel:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.queryTitle",{defaultMessage:"Query"}),getTipsHeading:()=>t.i18n.translate("xpack.canvas.uis.dataSources.timelion.tipsTitle",{defaultMessage:"Tips for using {timelion} in {canvas}",values:{timelion:n.C,canvas:n.c}})}},r={Math:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.mathTitle",{defaultMessage:"Measure"}),getValueDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.math.args.valueTitle",{defaultMessage:"Value"}),getValueHelp:()=>t.i18n.translate("xpack.canvas.uis.models.math.args.valueLabel",{defaultMessage:"Function and column to use in extracting a value from the datasource"})},PointSeries:{getColorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.colorTitle",{defaultMessage:"Color"}),getColorHelp:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.colorLabel",{defaultMessage:"Determines the color of a mark or series"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeriesTitle",{defaultMessage:"Dimensions & measures"}),getSizeDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.sizeTitle",{defaultMessage:"Size"}),getSizeHelp:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.sizeLabel",{defaultMessage:"Determine the size of a mark"}),getTextDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.textTitle",{defaultMessage:"Text"}),getTextHelp:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.textLabel",{defaultMessage:"Set the text to use as, or around, the mark"}),getXAxisDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.xaxisTitle",{defaultMessage:"X-axis"}),getXAxisHelp:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.xaxisLabel",{defaultMessage:"Data along the horizontal axis. Usually a number, string or date"}),getYaxisDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.yaxisTitle",{defaultMessage:"Y-axis"}),getYaxisHelp:()=>t.i18n.translate("xpack.canvas.uis.models.pointSeries.args.yaxisLabel",{defaultMessage:"Data along the vertical axis. Usually a number"})},HeatmapLegend:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.title",{defaultMessage:"Configure the heatmap chart's legend"}),getIsVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.isVisibleTitle",{defaultMessage:"Show legend"}),getIsVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.isVisibleLabel",{defaultMessage:"Specifies whether or not the legend is visible"}),getPositionDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionTitle",{defaultMessage:"Legend Position"}),getPositionHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionLabel",{defaultMessage:"Specifies the legend position."}),getPositionTopOption:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionTopLabel",{defaultMessage:"Top"}),getPositionBottomOption:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionBottomLabel",{defaultMessage:"Bottom"}),getPositionLeftOption:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionLeftLabel",{defaultMessage:"Left"}),getPositionRightOption:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionRightLabel",{defaultMessage:"Right"}),getMaxLinesDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.maxLinesTitle",{defaultMessage:"Legend maximum lines"}),getMaxLinesHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.maxLinesLabel",{defaultMessage:"Specifies the number of lines per legend item."}),getShouldTruncateDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.shouldTruncateTitle",{defaultMessage:"Truncate label"}),getShouldTruncateHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.shouldTruncateLabel",{defaultMessage:"Specifies whether or not the legend items should be truncated"})},HeatmapGrid:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.title",{defaultMessage:"Configure the heatmap layout"}),getStrokeWidthDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeWidthTitle",{defaultMessage:"Stroke width"}),getStrokeWidthHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeWidthLabel",{defaultMessage:"Specifies the grid stroke width"}),getStrokeColorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeColorTitle",{defaultMessage:"Stroke color"}),getStrokeColorHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeColorLabel",{defaultMessage:"Specifies the grid stroke color"}),getIsCellLabelVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isCellLabelVisibleTitle",{defaultMessage:"Show cell label"}),getIsCellLabelVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isCellLabelVisibleLabel",{defaultMessage:"Specifies whether or not the cell label is visible"}),getIsYAxisLabelVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisLabelVisibleTile",{defaultMessage:"Show Y-axis labels"}),getIsYAxisLabelVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisLabelVisibleLabel",{defaultMessage:"Specifies whether or not the Y-axis labels are visible"}),getIsYAxisTitleVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisTitleVisibleTile",{defaultMessage:"Show Y-axis title"}),getIsYAxisTitleVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisTitleVisibleLabel",{defaultMessage:"Specifies whether or not the Y-axis title is visible"}),getIsXAxisLabelVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisLabelVisibleTile",{defaultMessage:"Show X-axis labels"}),getIsXAxisLabelVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisLabelVisibleLabel",{defaultMessage:"Specifies whether or not the X-axis labels are visible"}),getIsXAxisTitleVisibleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisTitleVisibleTile",{defaultMessage:"Show X-axis title"}),getIsXAxisTitleVisibleHelp:()=>t.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisTitleVisibleLabel",{defaultMessage:"Specifies whether or not the X-axis title is visible"})},PartitionLabels:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.parititionLabels.title",{defaultMessage:"Configure chart labels"}),getShowDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.showTitle",{defaultMessage:"Show labels"}),getShowHelp:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.showDisplayName",{defaultMessage:"Show labels in a chart"}),getPositionDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.positionDisplayName",{defaultMessage:"Defines the label position"}),getPositionHelp:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.positionTitle",{defaultMessage:"Defines the label position"}),getPositionDefaultOption:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.positionDefaultOption",{defaultMessage:"Default"}),getPositionInsideOption:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.positionInsideOption",{defaultMessage:"Inside"}),getValuesDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesDisplayName",{defaultMessage:"Show values in labels"}),getValuesHelp:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesHelp",{defaultMessage:"Show values in labels"}),getPercentDecimalsDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.percentDecimalsDisplayName",{defaultMessage:"Percent decimals in in labels"}),getPercentDecimalsHelp:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.percentDecimalsHelp",{defaultMessage:"Defines the number of decimals that will appear on the values as percent"}),getValuesFormatDisplayName:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesFormatDisplayName",{defaultMessage:"Defines the format of the values"}),getValuesFormatHelp:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesFormatHelp",{defaultMessage:"Defines the format of the values"}),getValuesFormatPercentOption:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesFormatPercentDisplayName",{defaultMessage:"Percent"}),getValuesFormatValueOption:()=>t.i18n.translate("xpack.canvas.uis.models.partitionLabels.args.valuesFormatValueDisplayName",{defaultMessage:"Value"})}},o={FormatDate:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.formatDateTitle",{defaultMessage:"Date format"}),getFormatDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.formatDate.args.formatTitle",{defaultMessage:"Format"})},FormatNumber:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.formatNumberTitle",{defaultMessage:"Number format"}),getFormatDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.formatNumber.args.formatTitle",{defaultMessage:"Format"})},RoundDate:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.roundDateTitle",{defaultMessage:"Round date"}),getFormatDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.roundDate.args.formatTitle",{defaultMessage:"Format"}),getFormatHelp:()=>t.i18n.translate("xpack.canvas.uis.transforms.roundDate.args.formatLabel",{defaultMessage:"Select or enter a {momentJs} format to round the date",values:{momentJs:n.v}})},Sort:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.sortTitle",{defaultMessage:"Datatable sorting"}),getReverseDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.sort.args.reverseToggleSwitch",{defaultMessage:"Descending"}),getSortFieldDisplayName:()=>t.i18n.translate("xpack.canvas.uis.transforms.sort.args.sortFieldTitle",{defaultMessage:"Sort field"})}},c={DropdownControl:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControlTitle",{defaultMessage:"Dropdown filter"}),getFilterDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterColumnTitle",{defaultMessage:"Filter column"}),getFilterGroupDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterGroupTitle",{defaultMessage:"Filter group"}),getFilterGroupHelp:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterGroupLabel",{defaultMessage:"Apply the selected group name to an element's filters function to target this filter"}),getFilterHelp:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterColumnLabel",{defaultMessage:"Column to which the value selected from the dropdown is applied"}),getValueDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.valueColumnTitle",{defaultMessage:"Value column"}),getValueHelp:()=>t.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.valueColumnLabel",{defaultMessage:"Column from which to extract values to make available in the dropdown"})},GetCell:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.getCellTitle",{defaultMessage:"Dropdown filter"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.views.getCellLabel",{defaultMessage:"Grab the first row and first column"})},Image:{getContainMode:()=>t.i18n.translate("xpack.canvas.uis.views.image.args.mode.containDropDown",{defaultMessage:"Contain"}),getCoverMode:()=>t.i18n.translate("xpack.canvas.uis.views.image.args.mode.coverDropDown",{defaultMessage:"Cover"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.imageTitle",{defaultMessage:"Image"}),getModeDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.image.args.modeTitle",{defaultMessage:"Fill mode"}),getModeHelp:()=>t.i18n.translate("xpack.canvas.uis.views.image.args.modeLabel",{defaultMessage:"Note: Stretched fill may not work with vector images"}),getStretchMode:()=>t.i18n.translate("xpack.canvas.uis.views.image.args.mode.stretchDropDown",{defaultMessage:"Stretch"})},Markdown:{getContentDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.markdown.args.contentTitle",{defaultMessage:"{markdown} content",values:{markdown:n.u}}),getContentHelp:()=>t.i18n.translate("xpack.canvas.uis.views.markdown.args.contentLabel",{defaultMessage:"{markdown} formatted text",values:{markdown:n.u}}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.markdownTitle",{defaultMessage:"{markdown}",values:{markdown:n.u}}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.views.markdownLabel",{defaultMessage:"Generate markup using {markdown}",values:{markdown:n.u}}),getOpenLinksInNewTabDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabTitle",{defaultMessage:"Markdown link settings"}),getOpenLinksInNewTabLabelName:()=>t.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabLabel",{defaultMessage:"Open all links in a new tab"}),getOpenLinksInNewTabHelp:()=>t.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabHelpLabel",{defaultMessage:"Set links to open in new tab"})},Metric:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricTitle",{defaultMessage:"Metric"}),getNumberDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.numberArgTitle",{defaultMessage:"Value"}),getLabelDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.labelArgTitle",{defaultMessage:"Label"}),getLabelFontDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.labelFontTitle",{defaultMessage:"Label text"}),getLabelFontHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.labelFontLabel",{defaultMessage:"Fonts, alignment and color"}),getLabelHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.labelArgLabel",{defaultMessage:"Enter a text label for the metric value"}),getMetricFontDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.metricFontTitle",{defaultMessage:"Metric text"}),getMetricFontHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.metricFontLabel",{defaultMessage:"Fonts, alignment and color"}),getMetricFormatDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.metricFormatTitle",{defaultMessage:"Format"}),getMetricFormatHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metric.args.metricFormatLabel",{defaultMessage:"Select a format for the metric value"})},Pie:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pieTitle",{defaultMessage:"Chart style"}),getHoleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.holeTitle",{defaultMessage:"Inner radius"}),getHoleHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.holeLabel",{defaultMessage:"Radius of the hole"}),getLabelRadiusDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.labelRadiusTitle",{defaultMessage:"Label radius"}),getLabelRadiusHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.labelRadiusLabel",{defaultMessage:"Distance of the labels from the center of the pie"}),getLabelsDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.labelsTitle",{defaultMessage:"Labels"}),getLabelsToggleSwitch:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.labelsToggleSwitch",{defaultMessage:"Show labels"}),getLabelsHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.labelsLabel",{defaultMessage:"Show/hide labels"}),getLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.legendTitle",{defaultMessage:"Legend"}),getLegendHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.legendLabel",{defaultMessage:"Disable or position the legend"}),getRadiusDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.radiusTitle",{defaultMessage:"Radius"}),getRadiusHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.radiusLabel",{defaultMessage:"Radius of the pie"}),getTiltDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.tiltTitle",{defaultMessage:"Tilt angle"}),getTiltHelp:()=>t.i18n.translate("xpack.canvas.uis.views.pie.args.tiltLabel",{defaultMessage:"Percentage of tilt where 100 is fully vertical and 0 is completely flat"})},Plot:{getDefaultStyleDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.defaultStyleTitle",{defaultMessage:"Default style"}),getDefaultStyleHelp:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.defaultStyleLabel",{defaultMessage:"Set the style to be used by default by every series, unless overridden"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.plotTitle",{defaultMessage:"Chart style"}),getLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.legendTitle",{defaultMessage:"Legend"}),getLegendHelp:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.legendLabel",{defaultMessage:"Disable or position the legend"}),getXaxisDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.xaxisTitle",{defaultMessage:"X-axis"}),getXaxisHelp:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.xaxisLabel",{defaultMessage:"Configure or disable the x-axis"}),getYaxisDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.yaxisTitle",{defaultMessage:"Y-axis"}),getYaxisHelp:()=>t.i18n.translate("xpack.canvas.uis.views.plot.args.yaxisLabel",{defaultMessage:"Configure or disable the Y-axis"})},Progress:{getBarColorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.barColorTitle",{defaultMessage:"Background color"}),getBarColorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.barColorLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getBarWeightDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.barWeightTitle",{defaultMessage:"Background weight"}),getBarWeightHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.barWeightLabel",{defaultMessage:"Thickness of the background bar"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progressTitle",{defaultMessage:"Progress"}),getFontDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.fontTitle",{defaultMessage:"Label settings"}),getFontHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.fontLabel",{defaultMessage:"Font settings for the label. Technically, you can add other styles as well"}),getLabelDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.labelArgTitle",{defaultMessage:"Label"}),getLabelHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.labelArgLabel",{defaultMessage:"Set {true}/{false} to show/hide label or provide a string to display as the label",values:{true:n.b,false:n.a}}),getMaxDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.maxTitle",{defaultMessage:"Maximum value"}),getMaxHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.maxLabel",{defaultMessage:"Maximum value of the progress element"}),getShapeDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.shapeTitle",{defaultMessage:"Shape"}),getShapeHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.shapeLabel",{defaultMessage:"Shape of the progress indicator"}),getValueColorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.valueColorTitle",{defaultMessage:"Progress color"}),getValueColorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.valueColorLabel",{defaultMessage:"Accepts {hex}, {rgb} or {html} Color names",values:{html:n.n,hex:n.m,rgb:n.z}}),getValueWeightDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.valueWeightTitle",{defaultMessage:"Progress weight"}),getValueWeightHelp:()=>t.i18n.translate("xpack.canvas.uis.views.progress.args.valueWeightLabel",{defaultMessage:"Thickness of the progress bar"})},Render:{getCssApply:()=>t.i18n.translate("xpack.canvas.uis.views.render.args.css.applyButtonLabel",{defaultMessage:"Apply Stylesheet"}),getCssHelp:()=>t.i18n.translate("xpack.canvas.uis.views.render.args.cssLabel",{defaultMessage:"A {css} stylesheet scoped to your element",values:{css:n.e}}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.renderTitle",{defaultMessage:"Element style"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.views.renderLabel",{defaultMessage:"Setting for the container around your element"})},RepeatImage:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImageTitle",{defaultMessage:"Repeating image"}),getEmptyImageDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.emptyImageTitle",{defaultMessage:"Empty image"}),getEmptyImageHelp:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.emptyImageLabel",{defaultMessage:"An image to fill up the difference between the value and the max count"}),getImageDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.imageTitle",{defaultMessage:"Image"}),getImageHelp:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.imageLabel",{defaultMessage:"An image to repeat"}),getMaxDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.maxTitle",{defaultMessage:"Max count"}),getMaxHelp:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.maxLabel",{defaultMessage:"The maximum number of repeated images"}),getSizeDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.sizeTitle",{defaultMessage:"Image size"}),getSizeHelp:()=>t.i18n.translate("xpack.canvas.uis.views.repeatImage.args.sizeLabel",{defaultMessage:"The size of the largest dimension of the image. Eg, if the image is tall but not wide, this is the height"})},RevealImage:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.revealImageTitle",{defaultMessage:"Reveal image"}),getEmptyImageDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.emptyImageTitle",{defaultMessage:"Background image"}),getEmptyImageHelp:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.emptyImageLabel",{defaultMessage:"A background image. Eg, an empty glass"}),getImageDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.imageTitle",{defaultMessage:"Image"}),getImageHelp:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.imageLabel",{defaultMessage:"An image to reveal given the function input. Eg, a full glass"}),getOriginBottom:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.bottomDropDown",{defaultMessage:"Bottom"}),getOriginDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.originTitle",{defaultMessage:"Reveal from"}),getOriginHelp:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.originLabel",{defaultMessage:"The direction from which to start the reveal"}),getOriginLeft:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.leftDropDown",{defaultMessage:"Left"}),getOriginRight:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.rightDropDown",{defaultMessage:"Right"}),getOriginTop:()=>t.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.topDropDown",{defaultMessage:"Top"})},Shape:{getBorderDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.borderTitle",{defaultMessage:"Border"}),getBorderHelp:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.borderLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getBorderWidthDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.borderWidthTitle",{defaultMessage:"Border width"}),getBorderWidthHelp:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.borderWidthLabel",{defaultMessage:"Border width"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shapeTitle",{defaultMessage:"Shape"}),getFillDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.fillTitle",{defaultMessage:"Fill"}),getFillHelp:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.fillLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getMaintainAspectDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectTitle",{defaultMessage:"Aspect ratio settings"}),getMaintainAspectLabelName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectLabel",{defaultMessage:"Use a fixed ratio"}),getMaintainAspectHelp:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectHelpLabel",{defaultMessage:"Enable to maintain aspect ratio"}),getShapeDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.shape.args.shapeTitle",{defaultMessage:"Select shape"})},Table:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tableTitle",{defaultMessage:"Table style"}),getHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tableLabel",{defaultMessage:"Set styling for a Table element"}),getPaginateDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.paginateTitle",{defaultMessage:"Pagination"}),getPaginateToggleSwitch:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.paginateToggleSwitch",{defaultMessage:"Show pagination controls"}),getPaginateHelp:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.paginateLabel",{defaultMessage:"Show or hide pagination controls. If disabled only the first page will be shown"}),getPerPageDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.perPageTitle",{defaultMessage:"Rows"}),getPerPageHelp:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.perPageLabel",{defaultMessage:"Number of rows to display per table page"}),getShowHeaderDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderTitle",{defaultMessage:"Header"}),getShowHeaderToggleSwitch:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderToggleSwitch",{defaultMessage:"Show the header row"}),getShowHeaderHelp:()=>t.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderLabel",{defaultMessage:"Show or hide the header row with titles for each column"})},Timefilter:{getColumnConfirm:()=>t.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnConfirmButtonLabel",{defaultMessage:"Set"}),getColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnTitle",{defaultMessage:"Column"}),getColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnLabel",{defaultMessage:"Column to which selected time is applied"}),getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.timefilterTitle",{defaultMessage:"Time filter"}),getFilterGroupDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.timefilter.args.filterGroupTitle",{defaultMessage:"Filter group"}),getFilterGroupHelp:()=>t.i18n.translate("xpack.canvas.uis.views.timefilter.args.filterGroupLabel",{defaultMessage:"Apply the selected group name to an element's filters function to target this filter"})},Tagcloud:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloudTitle",{defaultMessage:"Tag Cloud"}),getScaleColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleDisplayName",{defaultMessage:"Scale"}),getScaleColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleHelp",{defaultMessage:"Scale to determine font size of a word"}),getScaleLinear:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleLinearLabel",{defaultMessage:"Linear"}),getScaleLog:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleLogLabel",{defaultMessage:"Log"}),getScaleSquareRoot:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleSquareRootLabel",{defaultMessage:"Square root"}),getOrientationColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationDisplayName",{defaultMessage:"Orientation"}),getOrientationColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationHelp",{defaultMessage:"Orientation of words inside tagcloud"}),getOrientationSingle:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationSingleLabel",{defaultMessage:"Single"}),getOrientationRightAngled:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationRightAngledLabel",{defaultMessage:"Right angled"}),getOrientationMultiple:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationMultipleLabel",{defaultMessage:"Multiple"}),getMinFontHeightColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.minFontHeightDisplayName",{defaultMessage:"Minimum font height"}),getMinFontHeightColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.minFontHeightHelp",{defaultMessage:"Minimum height of the element font"}),getMaxFontHeightColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.maxFontHeightDisplayName",{defaultMessage:"Maximum font height"}),getMaxFontHeightColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.maxFontHeightHelp",{defaultMessage:"Maximum height of the element font"}),getShowLabelColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.showLabelDisplayName",{defaultMessage:"Show label"}),getShowLabelColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.showLabelHelp",{defaultMessage:"Show label of the chart"}),getMetricColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.metricDisplayName",{defaultMessage:"Metric"}),getMetricColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.metricHelp",{defaultMessage:"Metric dimension configuration"}),getBucketColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.bucketDisplayName",{defaultMessage:"Bucket"}),getBucketColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.tagcloud.args.bucketHelp",{defaultMessage:"Bucket dimension configuration"})},MetricVis:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVisTitle",{defaultMessage:"Metric Vis"}),getMetricColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.metricDisplayName",{defaultMessage:"Metric"}),getMetricColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.metricHelp",{defaultMessage:"Metric dimension configuration"}),getBucketColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.bucketDisplayName",{defaultMessage:"Bucket"}),getBucketColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.bucketHelp",{defaultMessage:"Bucket dimension configuration"}),getFontColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.fontDisplayName",{defaultMessage:"Font"}),getFontColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.fontHelp",{defaultMessage:"Metric font configuration"}),getPercentageModeColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.percentageModeDisplayName",{defaultMessage:"Enable percentage mode"}),getPercentageModeColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.percentageModeHelp",{defaultMessage:"Shows metric in percentage mode."}),getShowLabelsColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.showLabelsDisplayName",{defaultMessage:"Show metric labels"}),getShowLabelsColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.showLabelsHelp",{defaultMessage:"Shows labels under the metric values."}),getColorModeColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorModeDisplayName",{defaultMessage:"Metric color mode"}),getColorModeColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorModeHelp",{defaultMessage:"Which part of metric to fill with color."}),getColorModeNoneOption:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.noneOption",{defaultMessage:"None"}),getColorModeLabelOption:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.labelsOption",{defaultMessage:"Labels"}),getColorModeBackgroundOption:()=>t.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.backgroundOption",{defaultMessage:"Background"})},Heatmap:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmapTitle",{defaultMessage:"Heatmap Visualization"}),getXAccessorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.xAccessorDisplayName",{defaultMessage:"X-axis"}),getXAccessorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.xAccessorHelp",{defaultMessage:"The name of the x axis column or the corresponding dimension"}),getYAccessorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.yAccessorDisplayName",{defaultMessage:"Y-axis"}),getYAccessorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.yAccessorHelp",{defaultMessage:"The name of the y axis column or the corresponding dimension"}),getValueAccessorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.valueAccessorDisplayName",{defaultMessage:"Value"}),getValueAccessorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.valueAccessorHelp",{defaultMessage:"The name of the value column or the corresponding dimension"}),getLegendHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.legendHelp",{defaultMessage:"Configure the heatmap chart's legend"}),getLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.legendDisplayName",{defaultMessage:"Heatmap legend"}),getGridConfigHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.gridConfigHelp",{defaultMessage:"Configure the heatmap layout"}),getGridConfigDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.gridConfigDisplayName",{defaultMessage:"Heatmap layout configuration"}),getSplitRowAccessorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitRowAccessorDisplayName",{defaultMessage:"Split row"}),getSplitRowAccessorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.plitRowAccessorHelp",{defaultMessage:"The id of the split row or the corresponding dimension"}),getSplitColumnAccessorDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitColumnAccessorDisplayName",{defaultMessage:"Split column"}),getSplitColumnAccessorHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitColumnAccessorHelp",{defaultMessage:"The id of the split column or the corresponding dimension"}),getShowTooltipDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.showTooltipDisplayName",{defaultMessage:"Show tooltip"}),getShowTooltipHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.showTooltipHelp",{defaultMessage:"Show tooltip on hover"}),getHighlightInHoverDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.highlightInHoverDisplayName",{defaultMessage:"Hightlight on hover"}),getHighlightInHoverHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.highlightInHoverHelp",{defaultMessage:"When this is enabled, it highlights the ranges of the same color on legend hover"}),getLastRangeIsRightOpenDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.lastRangeIsRightOpenDisplayName",{defaultMessage:"Last range is right open"}),getLastRangeIsRightOpenHelp:()=>t.i18n.translate("xpack.canvas.uis.views.heatmap.args.lastRangeIsRightOpenHelp",{defaultMessage:"If is set to true, the last range value will be right open"})},PieVis:{getDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.pieVisTitle",{defaultMessage:"(New) Pie Visualization"})},PartitionVis:{getMetricColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.metricDisplayName",{defaultMessage:"Metric"}),getMetricColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.metricHelp",{defaultMessage:"Metric dimension configuration"}),getBucketColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.bucketDisplayName",{defaultMessage:"Bucket"}),getBucketColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.bucketHelp",{defaultMessage:"Bucket dimension configuration"}),getSplitRowDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.splitRowDisplayName",{defaultMessage:"Split row"}),getSplitRowHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.splitRowHelp",{defaultMessage:"Split row dimension configuration"}),getSplitColumnDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.splitColumnDisplayName",{defaultMessage:"Split column"}),getSplitColumnHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.splitColumnHelp",{defaultMessage:"Split column dimension configuration"}),getAddTooltipDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.addTooltipDisplayName",{defaultMessage:"Tooltip"}),getAddTooltipHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.addTooltipHelp",{defaultMessage:"Show tooltip on hover"}),getAddTooltipToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.addTooltipToggleLabel",{defaultMessage:"Show tooltip"}),getLegendPositionDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionTitle",{defaultMessage:"Placement"}),getLegendPositionHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionLabel",{defaultMessage:"Set the legend position on the right, top, left, or bottom"}),getLegendPositionTopOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionTopLabel",{defaultMessage:"Top"}),getLegendPositionBottomOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionBottomLabel",{defaultMessage:"Bottom"}),getLegendPositionLeftOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionLeftLabel",{defaultMessage:"Left"}),getLegendPositionRightOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendPositionRightLabel",{defaultMessage:"Right"}),getLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendDisplayTitle",{defaultMessage:"Legend view"}),getLegendDisplayHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendDisplayLabel",{defaultMessage:"Show or hide the pie legend"}),getLegendDisplayDefaultOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendDisplayDefaultLabel",{defaultMessage:"Default"}),getLegendDisplayShowOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendDisplayShowLabel",{defaultMessage:"Show"}),getLegendDisplayHideOption:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.legendDisplayHideLabel",{defaultMessage:"Hide"}),getNestedLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.nestedLegendDisplayName",{defaultMessage:"Detail legend"}),getNestedLegendHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.nestedLegendHelp",{defaultMessage:"Include details in the legend"}),getNestedLegendToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.nestedLegendToggleLabel",{defaultMessage:"Show details"}),getTruncateLegendDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.truncateLegendDisplayName",{defaultMessage:"Legend text"}),getTruncateLegendHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.truncateLegendHelp",{defaultMessage:"Truncate the legend when it reaches the maximum width"}),getTruncateLegendToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.truncateLegendToggleLabel",{defaultMessage:"Truncate when long"}),getMaxLegendLinesDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.maxLegendLinesDisplayName",{defaultMessage:"Max legend lines"}),getMaxLegendLinesHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.maxLegendLinesHelp",{defaultMessage:"Set the maximum number of lines for each legend item"}),getDistictColorsDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.distinctColorsDisplayName",{defaultMessage:"Slice colors"}),getDistictColorsHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.distinctColorsHelp",{defaultMessage:"Use different colors for slices with unequal values"}),getDistictColorsToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.distictColorsToggleLabel",{defaultMessage:"Use distinct colors"}),getRespectSourceOrderDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.respectSourceOrderDisplayName",{defaultMessage:"Order of data"}),getRespectSourceOrderToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.respectSourceOrderToggleLabel",{defaultMessage:"Use original order"}),getRespectSourceOrderHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.respectSourceOrderHelp",{defaultMessage:"Display the data in its original order instead of sorting it"}),getIsDonutDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.isDonutDisplayName",{defaultMessage:"Donut"}),getIsDonutHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.isDonutHelp",{defaultMessage:"Show donut chart"}),getEmptySizeRatioDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.emptySizeRatioDisplayName",{defaultMessage:"Donut hole size"}),getEmptySizeRatioHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.emptySizeRatioHelp",{defaultMessage:"Set the inner diameter of the donut hole"}),getPaletteHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.paletteHelp",{defaultMessage:"Specify the colors for the slices in the pie"}),getStartFromSecondLargestSliceDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.startFromSecondLargestSliceDisplayName",{defaultMessage:"Slice placement"}),getStartFromSecondLargestSliceHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.startFromSecondLargestSliceHelp",{defaultMessage:"Place the second largest slice in the first position of the pie"}),getStartFromSecondLargestSliceToggleLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.startFromSecondLargestSliceToggleLabel",{defaultMessage:"Start with second slice"}),getLabelsDisplayName:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.labelsDisplayName",{defaultMessage:"Label configuration"}),getLabelsHelp:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.args.labelsHelp",{defaultMessage:"Show label settings"}),getEnableLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.options.enableHelp",{defaultMessage:"Enable"}),getSaveLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.options.saveHelp",{defaultMessage:"Save"}),getTruncateLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.options.truncateHelp",{defaultMessage:"Truncate"}),getShowLabel:()=>t.i18n.translate("xpack.canvas.uis.views.partitionVis.options.showHelp",{defaultMessage:"Show"})}}},127:function(e,a,s){"use strict";s.d(a,"a",(function(){return n}));var t=s(3);const n={time:{getCycleTimeText:(e,a)=>{switch(a){case"seconds":return t.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalSecondsText",{defaultMessage:"Every {seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:e}});case"minutes":return t.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalMinutesText",{defaultMessage:"Every {minutes} {minutes, plural, one {minute} other {minutes}}",values:{minutes:e}});case"hours":return t.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalHoursText",{defaultMessage:"Every {hours} {hours, plural, one {hour} other {hours}}",values:{hours:e}});case"days":return t.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalDaysText",{defaultMessage:"Every {days} {days, plural, one {day} other {days}}",values:{days:e}})}},getDaysText:e=>t.i18n.translate("xpack.canvas.units.time.days",{defaultMessage:"{days, plural, one {# day} other {# days}}",values:{days:e}}),getHoursText:e=>t.i18n.translate("xpack.canvas.units.time.hours",{defaultMessage:"{hours, plural, one {# hour} other {# hours}}",values:{hours:e}}),getMinutesText:e=>t.i18n.translate("xpack.canvas.units.time.minutes",{defaultMessage:"{minutes, plural, one {# minute} other {# minutes}}",values:{minutes:e}}),getSecondsText:e=>t.i18n.translate("xpack.canvas.units.time.seconds",{defaultMessage:"{seconds, plural, one {# second} other {# seconds}}",values:{seconds:e}})},quickRanges:{getYesterdayLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.yesterday",{defaultMessage:"Yesterday"}),getTodayLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.today",{defaultMessage:"Today"}),getLast24HoursLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last24Hours",{defaultMessage:"Last 24 hours"}),getLast7DaysLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last7Days",{defaultMessage:"Last 7 days"}),getLast2WeeksLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last2Weeks",{defaultMessage:"Last 2 weeks"}),getLast30DaysLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last30Days",{defaultMessage:"Last 30 days"}),getLast90DaysLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last90Days",{defaultMessage:"Last 90 days"}),getLast1YearLabel:()=>t.i18n.translate("xpack.canvas.units.quickRange.last1Year",{defaultMessage:"Last 1 year"})}}},157:function(e,a,s){"use strict";s.d(a,"a",(function(){return t})),s.d(a,"b",(function(){return l}));const t=e=>{const a=l();return e.map((e=>{const s=e(),{name:t}=s,n=a[t];if(n){const{displayName:e,help:a}=n;a&&(s.help=a),e&&(s.displayName=e)}return()=>s}))};var n=s(3);const l=()=>({areaChart:{displayName:n.i18n.translate("xpack.canvas.elements.areaChartDisplayName",{defaultMessage:"Area"}),help:n.i18n.translate("xpack.canvas.elements.areaChartHelpText",{defaultMessage:"A line chart with a filled body"})},bubbleChart:{displayName:n.i18n.translate("xpack.canvas.elements.bubbleChartDisplayName",{defaultMessage:"Bubble"}),help:n.i18n.translate("xpack.canvas.elements.bubbleChartHelpText",{defaultMessage:"A customizable bubble chart"})},debug:{displayName:n.i18n.translate("xpack.canvas.elements.debugDisplayName",{defaultMessage:"Debug data"}),help:n.i18n.translate("xpack.canvas.elements.debugHelpText",{defaultMessage:"Just dumps the configuration of the element"})},dropdownFilter:{displayName:n.i18n.translate("xpack.canvas.elements.dropdownFilterDisplayName",{defaultMessage:"Dropdown select"}),help:n.i18n.translate("xpack.canvas.elements.dropdownFilterHelpText",{defaultMessage:'A dropdown from which you can select values for an "exactly" filter'})},filterDebug:{displayName:n.i18n.translate("xpack.canvas.elements.filterDebugDisplayName",{defaultMessage:"Debug filters"}),help:n.i18n.translate("xpack.canvas.elements.filterDebugHelpText",{defaultMessage:"Shows the underlying global filters in a workpad"})},horizontalBarChart:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalBarChartDisplayName",{defaultMessage:"Horizontal bar"}),help:n.i18n.translate("xpack.canvas.elements.horizontalBarChartHelpText",{defaultMessage:"A customizable horizontal bar chart"})},horizontalProgressBar:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalProgressBarDisplayName",{defaultMessage:"Horizontal bar"}),help:n.i18n.translate("xpack.canvas.elements.horizontalProgressBarHelpText",{defaultMessage:"Displays progress as a portion of a horizontal bar"})},horizontalProgressPill:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalProgressPillDisplayName",{defaultMessage:"Horizontal pill"}),help:n.i18n.translate("xpack.canvas.elements.horizontalProgressPillHelpText",{defaultMessage:"Displays progress as a portion of a horizontal pill"})},image:{displayName:n.i18n.translate("xpack.canvas.elements.imageDisplayName",{defaultMessage:"Image"}),help:n.i18n.translate("xpack.canvas.elements.imageHelpText",{defaultMessage:"A static image"})},lineChart:{displayName:n.i18n.translate("xpack.canvas.elements.lineChartDisplayName",{defaultMessage:"Line"}),help:n.i18n.translate("xpack.canvas.elements.lineChartHelpText",{defaultMessage:"A customizable line chart"})},markdown:{displayName:n.i18n.translate("xpack.canvas.elements.markdownDisplayName",{defaultMessage:"Text"}),help:n.i18n.translate("xpack.canvas.elements.markdownHelpText",{defaultMessage:"Add text using Markdown"})},metric:{displayName:n.i18n.translate("xpack.canvas.elements.metricDisplayName",{defaultMessage:"Metric"}),help:n.i18n.translate("xpack.canvas.elements.metricHelpText",{defaultMessage:"A number with a label"})},pie:{displayName:n.i18n.translate("xpack.canvas.elements.pieDisplayName",{defaultMessage:"Pie"}),help:n.i18n.translate("xpack.canvas.elements.pieHelpText",{defaultMessage:"Pie chart"})},plot:{displayName:n.i18n.translate("xpack.canvas.elements.plotDisplayName",{defaultMessage:"Coordinate plot"}),help:n.i18n.translate("xpack.canvas.elements.plotHelpText",{defaultMessage:"Mixed line, bar or dot charts"})},progressGauge:{displayName:n.i18n.translate("xpack.canvas.elements.progressGaugeDisplayName",{defaultMessage:"Gauge"}),help:n.i18n.translate("xpack.canvas.elements.progressGaugeHelpText",{defaultMessage:"Displays progress as a portion of a gauge"})},progressSemicircle:{displayName:n.i18n.translate("xpack.canvas.elements.progressSemicircleDisplayName",{defaultMessage:"Semicircle"}),help:n.i18n.translate("xpack.canvas.elements.progressSemicircleHelpText",{defaultMessage:"Displays progress as a portion of a semicircle"})},progressWheel:{displayName:n.i18n.translate("xpack.canvas.elements.progressWheelDisplayName",{defaultMessage:"Wheel"}),help:n.i18n.translate("xpack.canvas.elements.progressWheelHelpText",{defaultMessage:"Displays progress as a portion of a wheel"})},repeatImage:{displayName:n.i18n.translate("xpack.canvas.elements.repeatImageDisplayName",{defaultMessage:"Image repeat"}),help:n.i18n.translate("xpack.canvas.elements.repeatImageHelpText",{defaultMessage:"Repeats an image N times"})},revealImage:{displayName:n.i18n.translate("xpack.canvas.elements.revealImageDisplayName",{defaultMessage:"Image reveal"}),help:n.i18n.translate("xpack.canvas.elements.revealImageHelpText",{defaultMessage:"Reveals a percentage of an image"})},shape:{displayName:n.i18n.translate("xpack.canvas.elements.shapeDisplayName",{defaultMessage:"Shape"}),help:n.i18n.translate("xpack.canvas.elements.shapeHelpText",{defaultMessage:"A customizable shape"})},table:{displayName:n.i18n.translate("xpack.canvas.elements.tableDisplayName",{defaultMessage:"Data table"}),help:n.i18n.translate("xpack.canvas.elements.tableHelpText",{defaultMessage:"A scrollable grid for displaying data in a tabular format"})},timeFilter:{displayName:n.i18n.translate("xpack.canvas.elements.timeFilterDisplayName",{defaultMessage:"Time filter"}),help:n.i18n.translate("xpack.canvas.elements.timeFilterHelpText",{defaultMessage:"Set a time window"})},verticalBarChart:{displayName:n.i18n.translate("xpack.canvas.elements.verticalBarChartDisplayName",{defaultMessage:"Vertical bar"}),help:n.i18n.translate("xpack.canvas.elements.verticalBarChartHelpText",{defaultMessage:"A customizable vertical bar chart"})},verticalProgressBar:{displayName:n.i18n.translate("xpack.canvas.elements.verticalProgressBarDisplayName",{defaultMessage:"Vertical bar"}),help:n.i18n.translate("xpack.canvas.elements.verticalProgressBarHelpText",{defaultMessage:"Displays progress as a portion of a vertical bar"})},verticalProgressPill:{displayName:n.i18n.translate("xpack.canvas.elements.verticalProgressPillDisplayName",{defaultMessage:"Vertical pill"}),help:n.i18n.translate("xpack.canvas.elements.verticalProgressPillHelpText",{defaultMessage:"Displays progress as a portion of a vertical pill"})},tagCloud:{displayName:n.i18n.translate("xpack.canvas.elements.tagCloudDisplayName",{defaultMessage:"Tag Cloud"}),help:n.i18n.translate("xpack.canvas.elements.tagCloudHelpText",{defaultMessage:"Tagcloud visualization"})},metricVis:{displayName:n.i18n.translate("xpack.canvas.elements.metricVisDisplayName",{defaultMessage:"Metric"}),help:n.i18n.translate("xpack.canvas.elements.metricVisHelpText",{defaultMessage:"Metric visualization"})},legacyMetricVis:{displayName:n.i18n.translate("xpack.canvas.elements.legacyMetricVisDisplayName",{defaultMessage:"Legacy Metric Vis"}),help:n.i18n.translate("xpack.canvas.elements.legacyMetricVisHelpText",{defaultMessage:"Legacy metric visualization. We recommend using metricVis instead."})},heatmap:{displayName:n.i18n.translate("xpack.canvas.elements.heatmapDisplayName",{defaultMessage:"Heatmap"}),help:n.i18n.translate("xpack.canvas.elements.heatmapHelpText",{defaultMessage:"Heatmap visualization"})},pieVis:{displayName:n.i18n.translate("xpack.canvas.elements.pieVisDisplayName",{defaultMessage:"(New) Pie Vis"}),help:n.i18n.translate("xpack.canvas.elements.pieVisHelpText",{defaultMessage:"Pie visualization"})}})},160:function(e,a,s){},161:function(e,a,s){},162:function(e,a,s){},163:function(e,a,s){},164:function(e,a,s){"use strict";let t;s.d(a,"a",(function(){return t})),function(e){e.luceneQueryString="luceneQueryString",e.time="time",e.exactly="exactly"}(t||(t={}))},165:function(e,a,s){"use strict";let t,n;s.d(a,"a",(function(){return t})),s.d(a,"b",(function(){return n})),s.d(a,"c",(function(){return l})),function(e){e.NORTH_WEST="nw",e.SOUTH_WEST="sw",e.NORTH_EAST="ne",e.SOUTH_EAST="se"}(t||(t={})),function(e){e.TOP="top",e.BOTTOM="bottom",e.LEFT="left",e.RIGHT="right"}(n||(n={}));const l=e=>!!e&&"axisConfig"===e.type},166:function(e,a,s){},167:function(e,a,s){},168:function(e,a,s){"use strict";let t;!function(e){e.FULLSCREEN="__fullscreen",e.REFRESH_INTERVAL="__refreshInterval",e.AUTOPLAY_INTERVAL="__autoplayInterval"}(t||(t={}))},169:function(e,a,s){},170:function(e,a,s){"use strict";let t;s.d(a,"a",(function(){return t})),s.d(a,"b",(function(){return n})),function(e){e.NONE="none",e.SOLID="solid",e.DOTTED="dotted",e.DASHED="dashed",e.DOUBLE="double",e.GROOVE="groove",e.RIDGE="ridge",e.INSET="inset",e.OUTSET="outset"}(t||(t={}));const n=e=>!!e&&Object.values(t).includes(e)},171:function(e,a,s){},172:function(e,a,s){"use strict";s.d(a,"a",(function(){return n})),s.d(a,"b",(function(){return l}));var t=s(57);let n;function l(){const{help:e,args:a}=Object(t.u)().compare,s=Object(t.t)().compare;return{name:"compare",help:e,aliases:["condition"],type:"boolean",inputTypes:["string","number","boolean","null"],args:{op:{aliases:["_"],types:["string"],default:"eq",help:a.op,options:Object.values(n)},to:{aliases:["this","b"],help:a.to}},fn:(e,a)=>{const t=e,{to:l,op:i}=a,r=typeof t==typeof l;switch(i){case n.EQ:return t===l;case n.NE:case n.NEQ:return t!==l;case n.LT:return!!r&&t<l;case n.LTE:return!!r&&t<=l;case n.GT:return!!r&&t>l;case n.GTE:return!!r&&t>=l;default:throw s.invalidCompareOperator(i,Object.values(n).join(", "))}}}}!function(e){e.EQ="eq",e.GT="gt",e.GTE="gte",e.LT="lt",e.LTE="lte",e.NE="ne",e.NEQ="neq"}(n||(n={}))},57:function(e,a,s){"use strict";s.d(a,"d",(function(){return l})),s.d(a,"c",(function(){return n.c})),s.d(a,"g",(function(){return n.t})),s.d(a,"k",(function(){return n.B})),s.d(a,"l",(function(){return n.C})),s.d(a,"m",(function(){return n.D})),s.d(a,"f",(function(){return i})),s.d(a,"a",(function(){return r})),s.d(a,"s",(function(){return o.b})),s.d(a,"u",(function(){return c.b})),s.d(a,"t",(function(){return c.a})),s.d(a,"h",(function(){return u})),s.d(a,"j",(function(){return p})),s.d(a,"n",(function(){return g})),s.d(a,"p",(function(){return d})),s.d(a,"b",(function(){return f.a})),s.d(a,"e",(function(){return f.b})),s.d(a,"i",(function(){return f.c})),s.d(a,"o",(function(){return f.d})),s.d(a,"r",(function(){return f.e})),s.d(a,"q",(function(){return m.a}));var t=s(3),n=s(58);const l={ReadOnlyBadge:{getText:()=>t.i18n.translate("xpack.canvas.badge.readOnly.text",{defaultMessage:"Read only"}),getTooltip:()=>t.i18n.translate("xpack.canvas.badge.readOnly.tooltip",{defaultMessage:"Unable to save {canvas} workpads",values:{canvas:n.c}})}},i={actionsElements:{getInvalidArgIndexErrorMessage:e=>t.i18n.translate("xpack.canvas.error.actionsElements.invaludArgIndexErrorMessage",{defaultMessage:"Invalid argument index: {index}",values:{index:e}}),getConvertToLensUnsupportedSavedVisualization:()=>t.i18n.translate("xpack.canvas.error.actionsElements.convertToLensUnsupportedErrrorMessage",{defaultMessage:"The legacy 'savedVisualization' Canvas function does not support Lens visualizations. Try replacing this element with an 'embeddable' Canvas function."})},esPersist:{getSaveFailureTitle:()=>t.i18n.translate("xpack.canvas.error.esPersist.saveFailureTitle",{defaultMessage:"Couldn't save your changes to Elasticsearch"}),getTooLargeErrorMessage:()=>t.i18n.translate("xpack.canvas.error.esPersist.tooLargeErrorMessage",{defaultMessage:"The server gave a response that the workpad data was too large. This usually means uploaded image assets that are too large for Kibana or a proxy. Try removing some assets in the asset manager."}),getUpdateFailureTitle:()=>t.i18n.translate("xpack.canvas.error.esPersist.updateFailureTitle",{defaultMessage:"Couldn't update workpad"})},esService:{getDefaultIndexFetchErrorMessage:()=>t.i18n.translate("xpack.canvas.error.esService.defaultIndexFetchErrorMessage",{defaultMessage:"Couldn't fetch default index"}),getFieldsFetchErrorMessage:e=>t.i18n.translate("xpack.canvas.error.esService.fieldsFetchErrorMessage",{defaultMessage:"Couldn't fetch Elasticsearch fields for '{index}'",values:{index:e}}),getIndicesFetchErrorMessage:()=>t.i18n.translate("xpack.canvas.error.esService.indicesFetchErrorMessage",{defaultMessage:"Couldn't fetch Elasticsearch indices"})},RenderWithFn:{getRenderErrorMessage:e=>t.i18n.translate("xpack.canvas.error.RenderWithFn.renderErrorMessage",{defaultMessage:"Rendering '{functionName}' failed",values:{functionName:e||"function"}})},WorkpadDropzone:{getTooManyFilesErrorMessage:()=>t.i18n.translate("xpack.canvas.error.workpadDropzone.tooManyFilesErrorMessage",{defaultMessage:"One one file can be uploaded at a time"})},workpadRoutes:{getCreateFailureErrorMessage:()=>t.i18n.translate("xpack.canvas.error.workpadRoutes.createFailureErrorMessage",{defaultMessage:"Couldn't create workpad"}),getLoadFailureErrorMessage:()=>t.i18n.translate("xpack.canvas.error.workpadRoutes.loadFailureErrorMessage",{defaultMessage:"Couldn't load workpad with ID"})}},r={Color:{getDisplayName:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.colorDisplayName",{defaultMessage:"Color"}),getHelp:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.colorHelp",{defaultMessage:"Color picker"})},ContainerStyle:{getDisplayName:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyleTitle",{defaultMessage:"Container style"}),getHelp:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyleLabel",{defaultMessage:"Tweak the appearance of the element container"}),getAppearanceTitle:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.appearanceTitle",{defaultMessage:"Appearance"}),getBorderTitle:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.borderTitle",{defaultMessage:"Border"}),getPaddingLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.paddingLabel",{defaultMessage:"Padding"}),getOpacityLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.opacityLabel",{defaultMessage:"Opacity"}),getOverflowLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowLabel",{defaultMessage:"Overflow"}),getOverflowHiddenOption:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowHiddenDropDown",{defaultMessage:"Hidden"}),getOverflowVisibleOption:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowVisibleDropDown",{defaultMessage:"Visible"}),getThicknessLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.thicknessLabel",{defaultMessage:"Thickness"}),getStyleLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.styleLabel",{defaultMessage:"Style"}),getRadiusLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.radiusLabel",{defaultMessage:"Radius"}),getColorLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.colorLabel",{defaultMessage:"Color"})},Font:{getDisplayName:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.fontTitle",{defaultMessage:"Text settings"}),getHelp:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.fontHelpLabel",{defaultMessage:"Set the font, size and color"})},SeriesStyle:{getDisplayName:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyleTitle",{defaultMessage:"Series style"}),getHelp:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyleLabel",{defaultMessage:"Set the style for a selected named series"}),getColorLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.colorLabel",{defaultMessage:"Color"}),getColorValueDefault:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.colorValueDefault",{defaultMessage:"Auto"}),getStyleLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.styleLabel",{defaultMessage:"Style"}),getRemoveAriaLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.removeAriaLabel",{defaultMessage:"Remove series color"}),getNoSeriesTooltip:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.noSeriesTooltip",{defaultMessage:"Data has no series to style, add a color dimension"}),getSeriesIdentifierLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.seriesIdentifierLabel",{defaultMessage:"Series id"}),getSelectSeriesOption:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.selectSeriesDropDown",{defaultMessage:"Select series"}),getLineLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.lineLabel",{defaultMessage:"Line"}),getBarLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.barLabel",{defaultMessage:"Bar"}),getPointLabel:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.pointLabel",{defaultMessage:"Point"}),getNoneOption:()=>t.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.noneDropDown",{defaultMessage:"None"})}};var o=s(157),c=s(122);const u={Palettes:{getEarthTones:()=>t.i18n.translate("xpack.canvas.lib.palettes.earthTonesLabel",{defaultMessage:"Earth Tones"}),getCanvas:()=>t.i18n.translate("xpack.canvas.lib.palettes.canvasLabel",{defaultMessage:"{CANVAS}",values:{CANVAS:n.c}}),getColorBlind:()=>t.i18n.translate("xpack.canvas.lib.palettes.colorBlindLabel",{defaultMessage:"Color Blind"}),getElasticTeal:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticTealLabel",{defaultMessage:"Elastic Teal"}),getElasticBlue:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticBlueLabel",{defaultMessage:"Elastic Blue"}),getElasticYellow:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticYellowLabel",{defaultMessage:"Elastic Yellow"}),getElasticPink:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticPinkLabel",{defaultMessage:"Elastic Pink"}),getElasticGreen:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticGreenLabel",{defaultMessage:"Elastic Green"}),getElasticOrange:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticOrangeLabel",{defaultMessage:"Elastic Orange"}),getElasticPurple:()=>t.i18n.translate("xpack.canvas.lib.palettes.elasticPurpleLabel",{defaultMessage:"Elastic Purple"}),getGreenBlueRed:()=>t.i18n.translate("xpack.canvas.lib.palettes.greenBlueRedLabel",{defaultMessage:"Green, Blue, Red"}),getYellowGreen:()=>t.i18n.translate("xpack.canvas.lib.palettes.yellowGreenLabel",{defaultMessage:"Yellow, Green"}),getYellowBlue:()=>t.i18n.translate("xpack.canvas.lib.palettes.yellowBlueLabel",{defaultMessage:"Yellow, Blue"}),getYellowRed:()=>t.i18n.translate("xpack.canvas.lib.palettes.yellowRedLabel",{defaultMessage:"Yellow, Red"}),getInstagram:()=>t.i18n.translate("xpack.canvas.lib.palettes.instagramLabel",{defaultMessage:"{INSTAGRAM}",values:{INSTAGRAM:n.o}})}},p={advancedFilter:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.advancedFilter.displayName",{defaultMessage:"Advanced filter"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.advancedFilter.helpDescription",{defaultMessage:"Render a Canvas filter expression"})},debug:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.debug.displayName",{defaultMessage:"Debug"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.debug.helpDescription",{defaultMessage:"Render debug output as formatted {JSON}",values:{JSON:n.r}})},dropdownFilter:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.dropdownFilter.displayName",{defaultMessage:"Dropdown filter"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.dropdownFilter.helpDescription",{defaultMessage:'A dropdown from which you can select values for an "{exactly}" filter',values:{exactly:"exactly"}})},embeddable:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.embeddable.displayName",{defaultMessage:"Embeddable"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.embeddable.helpDescription",{defaultMessage:"Renders an embeddable Saved Object from other parts of Kibana"})},markdown:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.markdown.displayName",{defaultMessage:"Markdown"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.markdown.helpDescription",{defaultMessage:"Render {HTML} using {MARKDOWN} input",values:{HTML:n.n,MARKDOWN:n.u}})},pie:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.pie.displayName",{defaultMessage:"Pie chart"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.pie.helpDescription",{defaultMessage:"Render a pie chart from data"})},plot:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.plot.displayName",{defaultMessage:"Coordinate plot"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.plot.helpDescription",{defaultMessage:"Render an XY plot from your data"})},table:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.table.displayName",{defaultMessage:"Data table"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.table.helpDescription",{defaultMessage:"Render tabular data as {HTML}",values:{HTML:n.n}})},text:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.text.displayName",{defaultMessage:"Plain text"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.text.helpDescription",{defaultMessage:"Render output as plain text"})},timeFilter:{getDisplayName:()=>t.i18n.translate("xpack.canvas.renderer.timeFilter.displayName",{defaultMessage:"Time filter"}),getHelpDescription:()=>t.i18n.translate("xpack.canvas.renderer.timeFilter.helpDescription",{defaultMessage:"Set a time window to filter your data"})}};s(97);const g={presentation:()=>t.i18n.translate("xpack.canvas.tags.presentationTag",{defaultMessage:"presentation"}),report:()=>t.i18n.translate("xpack.canvas.tags.reportTag",{defaultMessage:"report"})},d={fade:{getDisplayName:()=>t.i18n.translate("xpack.canvas.transitions.fade.displayName",{defaultMessage:"Fade"}),getHelp:()=>t.i18n.translate("xpack.canvas.transitions.fade.help",{defaultMessage:"Fade from one page to the next"})},rotate:{getDisplayName:()=>t.i18n.translate("xpack.canvas.transitions.rotate.displayName",{defaultMessage:"Rotate"}),getHelp:()=>t.i18n.translate("xpack.canvas.transitions.rotate.help",{defaultMessage:"Rotate from one page to the next"})},slide:{getDisplayName:()=>t.i18n.translate("xpack.canvas.transitions.slide.displayName",{defaultMessage:"Slide"}),getHelp:()=>t.i18n.translate("xpack.canvas.transitions.slide.help",{defaultMessage:"Slide from one page to the next"})},zoom:{getDisplayName:()=>t.i18n.translate("xpack.canvas.transitions.zoom.displayName",{defaultMessage:"Zoom"}),getHelp:()=>t.i18n.translate("xpack.canvas.transitions.zoom.help",{defaultMessage:"Zoom from one page to the next"})}};var f=s(126),m=s(127)},58:function(e,a,s){"use strict";s.d(a,"a",(function(){return t})),s.d(a,"b",(function(){return n})),s.d(a,"c",(function(){return l})),s.d(a,"d",(function(){return i})),s.d(a,"e",(function(){return r})),s.d(a,"f",(function(){return o})),s.d(a,"h",(function(){return c})),s.d(a,"g",(function(){return u})),s.d(a,"i",(function(){return p})),s.d(a,"j",(function(){return g})),s.d(a,"k",(function(){return d})),s.d(a,"l",(function(){return f})),s.d(a,"m",(function(){return m})),s.d(a,"n",(function(){return v})),s.d(a,"o",(function(){return x})),s.d(a,"p",(function(){return h})),s.d(a,"q",(function(){return T})),s.d(a,"r",(function(){return M})),s.d(a,"s",(function(){return k})),s.d(a,"t",(function(){return y})),s.d(a,"u",(function(){return b})),s.d(a,"v",(function(){return w})),s.d(a,"w",(function(){return S})),s.d(a,"x",(function(){return L})),s.d(a,"y",(function(){return H})),s.d(a,"z",(function(){return D})),s.d(a,"A",(function(){return N})),s.d(a,"B",(function(){return E})),s.d(a,"C",(function(){return C})),s.d(a,"D",(function(){return A})),s.d(a,"E",(function(){return F})),s.d(a,"F",(function(){return O})),s.d(a,"G",(function(){return I})),s.d(a,"H",(function(){return R})),s.d(a,"I",(function(){return B})),s.d(a,"J",(function(){return V})),s.d(a,"K",(function(){return P})),s.d(a,"L",(function(){return _}));const t="`false`",n="`true`",l="Canvas",i="_context_",r="CSS",o="CSV",c="`datemath`",u="`datatable`",p="Elasticsearch",g="ES",d="`font-family`",f="`font-weight`",m="HEX",v="HTML",x="Instagram",h="ISO8601",T="JavaScript",M="JSON",k="Lucene",y="https://www.elastic.co/guide/en/kibana/current/lucene-query.html",b="Markdown",w="MomentJS",S="https://momentjs.com/timezone/",L="Numeral pattern",H="PDF",D="RGB",N="SQL",E="https://www.elastic.co/guide/en/elasticsearch/reference/current/sql-spec.html",C="Timelion",A="https://www.elastic.co/blog/timelion-tutorial-from-zero-to-hero",F="`TinyMath`",O="https://www.elastic.co/guide/en/kibana/current/canvas-tinymath-functions.html",I="`boolean`",R="`null`",B="`number`",V="`string`",P="URL",_="ZIP"},69:function(e,a,s){"use strict";var t=s(4);s.o(t,"BackgroundRepeat")&&s.d(a,"BackgroundRepeat",(function(){return t.BackgroundRepeat})),s.o(t,"BackgroundSize")&&s.d(a,"BackgroundSize",(function(){return t.BackgroundSize})),s.o(t,"BorderStyle")&&s.d(a,"BorderStyle",(function(){return t.BorderStyle})),s.o(t,"FilterType")&&s.d(a,"FilterType",(function(){return t.FilterType})),s.o(t,"Legend")&&s.d(a,"Legend",(function(){return t.Legend})),s.o(t,"Overflow")&&s.d(a,"Overflow",(function(){return t.Overflow})),s.o(t,"Position")&&s.d(a,"Position",(function(){return t.Position})),s.o(t,"getType")&&s.d(a,"getType",(function(){return t.getType})),s.o(t,"isAxisConfig")&&s.d(a,"isAxisConfig",(function(){return t.isAxisConfig})),s.o(t,"isBorderStyle")&&s.d(a,"isBorderStyle",(function(){return t.isBorderStyle})),s(160),s(161),s(162),s(163);var n=s(164);s.d(a,"FilterType",(function(){return n.a}));var l=s(165);s.d(a,"Legend",(function(){return l.a})),s.d(a,"Position",(function(){return l.b})),s.d(a,"isAxisConfig",(function(){return l.c})),s(166),s(167),s(168),s(169);var i=s(170);s.d(a,"BorderStyle",(function(){return i.a})),s.d(a,"isBorderStyle",(function(){return i.b})),s(171)},97:function(e,a,s){"use strict";s.d(a,"a",(function(){return l}));var t=s(3),n=s(0);const l={getNamespaceDisplayNames:()=>({ELEMENT:t.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.elementDisplayName",{defaultMessage:"Element controls"}),EXPRESSION:t.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.expressionDisplayName",{defaultMessage:"Expression controls"}),EDITOR:t.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.editorDisplayName",{defaultMessage:"Editor controls"}),PRESENTATION:t.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.presentationDisplayName",{defaultMessage:"Presentation controls"})}),getShortcutHelp:()=>({CUT:t.i18n.translate("xpack.canvas.keyboardShortcuts.cutShortcutHelpText",{defaultMessage:"Cut"}),COPY:t.i18n.translate("xpack.canvas.keyboardShortcuts.copyShortcutHelpText",{defaultMessage:"Copy"}),PASTE:t.i18n.translate("xpack.canvas.keyboardShortcuts.pasteShortcutHelpText",{defaultMessage:"Paste"}),CLONE:t.i18n.translate("xpack.canvas.keyboardShortcuts.cloneShortcutHelpText",{defaultMessage:"Clone"}),DELETE:t.i18n.translate("xpack.canvas.keyboardShortcuts.deleteShortcutHelpText",{defaultMessage:"Delete"}),BRING_FORWARD:t.i18n.translate("xpack.canvas.keyboardShortcuts.bringFowardShortcutHelpText",{defaultMessage:"Bring forward"}),BRING_TO_FRONT:t.i18n.translate("xpack.canvas.keyboardShortcuts.bringToFrontShortcutHelpText",{defaultMessage:"Bring to front"}),SEND_BACKWARD:t.i18n.translate("xpack.canvas.keyboardShortcuts.sendBackwardShortcutHelpText",{defaultMessage:"Send backward"}),SEND_TO_BACK:t.i18n.translate("xpack.canvas.keyboardShortcuts.sendToBackShortcutHelpText",{defaultMessage:"Send to back"}),GROUP:t.i18n.translate("xpack.canvas.keyboardShortcuts.groupShortcutHelpText",{defaultMessage:"Group"}),UNGROUP:t.i18n.translate("xpack.canvas.keyboardShortcuts.ungroupShortcutHelpText",{defaultMessage:"Ungroup"}),SHIFT_UP:t.i18n.translate("xpack.canvas.keyboardShortcuts.shiftUpShortcutHelpText",{defaultMessage:"Shift up by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.t}}),SHIFT_DOWN:t.i18n.translate("xpack.canvas.keyboardShortcuts.shiftDownShortcutHelpText",{defaultMessage:"Shift down by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.t}}),SHIFT_LEFT:t.i18n.translate("xpack.canvas.keyboardShortcuts.shiftLeftShortcutHelpText",{defaultMessage:"Shift left by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.t}}),SHIFT_RIGHT:t.i18n.translate("xpack.canvas.keyboardShortcuts.shiftRightShortcutHelpText",{defaultMessage:"Shift right by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.t}}),NUDGE_UP:t.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeUpShortcutHelpText",{defaultMessage:"Shift up by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.s}}),NUDGE_DOWN:t.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeDownShortcutHelpText",{defaultMessage:"Shift down by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.s}}),NUDGE_LEFT:t.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeLeftShortcutHelpText",{defaultMessage:"Shift left by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.s}}),NUDGE_RIGHT:t.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeRightShortcutHelpText",{defaultMessage:"Shift right by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.s}}),RUN:t.i18n.translate("xpack.canvas.keyboardShortcuts.runShortcutHelpText",{defaultMessage:"Run whole expression"}),MULTISELECT:t.i18n.translate("xpack.canvas.keyboardShortcuts.multiselectShortcutHelpText",{defaultMessage:"Select multiple elements"}),RESIZE_FROM_CENTER:t.i18n.translate("xpack.canvas.keyboardShortcuts.resizeFromCenterShortcutHelpText",{defaultMessage:"Resize from center"}),IGNORE_SNAP:t.i18n.translate("xpack.canvas.keyboardShortcuts.ignoreSnapShortcutHelpText",{defaultMessage:"Move, resize, and rotate without snapping"}),SELECT_BEHIND:t.i18n.translate("xpack.canvas.keyboardShortcuts.selectBehindShortcutHelpText",{defaultMessage:"Select element below"}),UNDO:t.i18n.translate("xpack.canvas.keyboardShortcuts.undoShortcutHelpText",{defaultMessage:"Undo last action"}),REDO:t.i18n.translate("xpack.canvas.keyboardShortcuts.redoShortcutHelpText",{defaultMessage:"Redo last action"}),PREV:t.i18n.translate("xpack.canvas.keyboardShortcuts.prevShortcutHelpText",{defaultMessage:"Go to previous page"}),NEXT:t.i18n.translate("xpack.canvas.keyboardShortcuts.nextShortcutHelpText",{defaultMessage:"Go to next page"}),EDITING:t.i18n.translate("xpack.canvas.keyboardShortcuts.editingShortcutHelpText",{defaultMessage:"Toggle edit mode"}),GRID:t.i18n.translate("xpack.canvas.keyboardShortcuts.gridShortcutHelpText",{defaultMessage:"Show grid"}),REFRESH:t.i18n.translate("xpack.canvas.keyboardShortcuts.ShortcutHelpText",{defaultMessage:"Refresh workpad"}),ZOOM_IN:t.i18n.translate("xpack.canvas.keyboardShortcuts.zoomInShortcutHelpText",{defaultMessage:"Zoom in"}),ZOOM_OUT:t.i18n.translate("xpack.canvas.keyboardShortcuts.zoomOutShortcutHelpText",{defaultMessage:"Zoom out"}),ZOOM_RESET:t.i18n.translate("xpack.canvas.keyboardShortcuts.zoomResetShortcutHelpText",{defaultMessage:"Reset zoom to 100%"}),FULLSCREEN:t.i18n.translate("xpack.canvas.keyboardShortcuts.fullscreenShortcutHelpText",{defaultMessage:"Enter presentation mode"}),FULLSCREEN_EXIT:t.i18n.translate("xpack.canvas.keyboardShortcuts.fullscreenExitShortcutHelpText",{defaultMessage:"Exit presentation mode"}),PAGE_CYCLE_TOGGLE:t.i18n.translate("xpack.canvas.keyboardShortcuts.pageCycleToggleShortcutHelpText",{defaultMessage:"Toggle page cycling"})})}}}]);