"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transientReducer = void 0;
var _reduxActions = require("redux-actions");
var _objectPathImmutable = _interopRequireDefault(require("object-path-immutable"));
var _history = require("../actions/history");
var pageActions = _interopRequireWildcard(require("../actions/pages"));
var transientActions = _interopRequireWildcard(require("../actions/transient"));
var _elements = require("../actions/elements");
var _workpad = require("../actions/workpad");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  set,
  del
} = _objectPathImmutable.default;
const transientReducer = (0, _reduxActions.handleActions)({
  // clear all the resolved args when restoring the history
  // TODO: we shouldn't need to reset the resolved args for history
  [_history.restoreHistory]: transientState => set(transientState, 'resolvedArgs', {}),
  [_elements.removeElements]: (transientState, {
    payload: {
      elementIds
    }
  }) => {
    const {
      selectedToplevelNodes
    } = transientState;
    return del({
      ...transientState,
      selectedToplevelNodes: selectedToplevelNodes.filter(n => elementIds.indexOf(n) < 0)
    }, ['resolvedArgs', elementIds]);
  },
  [transientActions.setFirstLoad]: (transientState, {
    payload
  }) => {
    return set(transientState, 'isFirstLoad', Boolean(payload));
  },
  [transientActions.setFullscreen]: (transientState, {
    payload
  }) => {
    return set(transientState, 'fullscreen', Boolean(payload));
  },
  [transientActions.setElementStats]: (transientState, {
    payload
  }) => {
    return set(transientState, 'elementStats', payload);
  },
  [transientActions.selectToplevelNodes]: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      selectedToplevelNodes: payload
    };
  },
  [transientActions.setZoomScale]: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      zoomScale: payload || 1
    };
  },
  [pageActions.setPage]: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  [pageActions.addPage]: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  [pageActions.duplicatePage]: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  [_workpad.setRefreshInterval]: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      refresh: {
        interval: Number(payload) || 0
      }
    };
  },
  [_workpad.enableAutoplay]: (transientState, {
    payload
  }) => {
    return set(transientState, 'autoplay.enabled', Boolean(payload) || false);
  },
  [_workpad.setAutoplayInterval]: (transientState, {
    payload
  }) => {
    return set(transientState, 'autoplay.interval', Number(payload) || 0);
  }
}, {});
exports.transientReducer = transientReducer;