"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupExpressions = void 0;
var _common = require("@kbn/expressions-plugin/common");
var _constants = require("../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let cached = null;

// TODO: clintandrewhall - This is getting refactored shortly.  https://github.com/elastic/kibana/issues/105675
const setupExpressions = async ({
  coreSetup,
  setupPlugins
}) => {
  const {
    expressions,
    bfetch
  } = setupPlugins;
  const loadServerFunctionWrappers = async () => {
    if (!cached) {
      cached = (async () => {
        const serverFunctionList = await coreSetup.http.get(_constants.API_ROUTE_FUNCTIONS, {
          version: '1'
        });
        const batchedFunction = bfetch.batchedFunction({
          url: _constants.API_ROUTE_FUNCTIONS
        });
        const {
          serialize
        } = (0, _common.serializeProvider)(expressions.getTypes());

        // For every sever-side function, register a client-side
        // function that matches its definition, but which simply
        // calls the server-side function endpoint.
        Object.keys(serverFunctionList).forEach(functionName => {
          if (expressions.getFunction(functionName)) {
            return;
          }
          const fn = () => ({
            ...serverFunctionList[functionName],
            fn: (input, args) => {
              return batchedFunction({
                functionName,
                args,
                context: serialize(input)
              });
            }
          });
          expressions.registerFunction(fn);
        });
      })();
    }
    return cached;
  };
  await loadServerFunctionWrappers();
};
exports.setupExpressions = setupExpressions;