"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InteractivePage = void 0;
var _recompose = require("recompose");
var _reactRedux = require("react-redux");
var _store = require("../../../lib/aeroelastic/store");
var _layout = require("../../../lib/aeroelastic/layout");
var _workpad = require("../../../state/selectors/workpad");
var _functional = require("../../../lib/aeroelastic/functional");
var _app = require("../../../state/selectors/app");
var _elements = require("../../../state/actions/elements");
var _transient = require("../../../state/actions/transient");
var _integration_utils = require("../integration_utils");
var _lib = require("../../../../common/lib");
var _interactive_workpad_page = require("./interactive_workpad_page");
var _event_handlers = require("./event_handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configuration = {
  getAdHocChildAnnotationName: 'adHocChildAnnotation',
  adHocGroupName: 'adHocGroup',
  alignmentGuideName: 'alignmentGuide',
  atopZ: 1000,
  depthSelect: true,
  devColor: 'magenta',
  dragBoxAnnotationName: 'dragBoxAnnotation',
  dragBoxZ: 1050,
  // above alignment guides but below the upcoming hover tooltip
  groupName: 'group',
  groupResize: true,
  guideDistance: 3,
  hoverAnnotationName: 'hoverAnnotation',
  hoverLift: 100,
  intraGroupManipulation: false,
  intraGroupSnapOnly: false,
  minimumElementSize: 2,
  persistentGroupName: 'persistentGroup',
  resizeAnnotationConnectorOffset: 0,
  resizeAnnotationOffset: 0,
  resizeAnnotationOffsetZ: 0.1,
  // causes resize markers to be slightly above the shape plane
  resizeAnnotationSize: 10,
  resizeConnectorName: 'resizeConnector',
  resizeHandleName: 'resizeHandle',
  rotateAnnotationOffset: 12,
  rotateSnapInPixels: 10,
  rotationEpsilon: 0.001,
  rotationHandleName: 'rotationHandle',
  rotationHandleSize: 14,
  rotationTooltipName: 'rotationTooltip',
  shortcuts: false,
  singleSelect: false,
  snapConstraint: true,
  tooltipZ: 1100
};

// Polyfill for browsers (IE11) that don't have element.closest
// From: https://developer.mozilla.org/en-US/docs/Web/API/Element/closest
function closest(s) {
  let el = this;
  const matchFn = el.matches ? 'matches' : 'msMatchesSelector';
  do {
    if (el[matchFn](s)) {
      return el;
    }
    el = el.parentElement || el.parentNode;
  } while (el !== null && el.nodeType === 1);
  return null;
}

// If you interact with an embeddable panel, only the header should be draggable
// This function will determine if an element is an embeddable body or not
const isEmbeddableBody = element => {
  const hasClosest = typeof element.closest === 'function';
  if (hasClosest) {
    return element.closest(`.${_lib.CANVAS_EMBEDDABLE_CLASSNAME}`) && !element.closest('.embPanel__header');
  } else {
    return closest.call(element, `.${_lib.CANVAS_EMBEDDABLE_CLASSNAME}`) && !closest.call(element, '.embPanel__header');
  }
};
const isEuiSelect = element => {
  const hasClosest = typeof element.closest === 'function';
  if (hasClosest) {
    return element.closest(`.euiSelect`);
  } else {
    return closest.call(element, `.euiSelect`);
  }
};

// Some elements in an embeddable may be portaled out of the embeddable container.
// We do not want clicks on those to trigger drags, etc, in the workpad. This function
// will check to make sure the clicked item is actually in the container
const isInWorkpad = element => {
  const hasClosest = typeof element.closest === 'function';
  const workpadContainerSelector = '.canvasWorkpadContainer';
  if (hasClosest) {
    return !!element.closest(workpadContainerSelector);
  } else {
    return !!closest.call(element, workpadContainerSelector);
  }
};
const componentLayoutState = ({
  aeroStore,
  setAeroStore,
  elements,
  selectedToplevelNodes,
  height,
  width
}) => {
  const shapes = (0, _integration_utils.shapesForNodes)(elements);
  const selectedShapes = selectedToplevelNodes.filter(e => shapes.find(s => s.id === e));
  const newState = {
    primaryUpdate: null,
    currentScene: {
      shapes,
      configuration: {
        ...configuration,
        pageHeight: height,
        pageWidth: width
      },
      selectedShapes,
      selectionState: aeroStore ? aeroStore.getCurrentState().currentScene.selectionState : {
        uid: 0,
        depthIndex: 0,
        down: false
      },
      gestureState: aeroStore ? aeroStore.getCurrentState().currentScene.gestureState : {
        cursor: {
          x: Infinity,
          y: Infinity
        },
        mouseIsDown: false,
        mouseButtonState: {
          buttonState: 'up',
          downX: null,
          downY: null
        }
      }
    }
  };
  if (aeroStore) {
    aeroStore.setCurrentState(newState);
  } else {
    setAeroStore(aeroStore = (0, _store.createStore)(newState, _layout.updater));
  }
  return {
    aeroStore
  };
};
const mapStateToProps = (state, ownProps) => {
  const selectedToplevelNodes = state.transient.selectedToplevelNodes;
  const nodes = (0, _workpad.getNodes)(state, ownProps.pageId);
  const selectedPrimaryShapeObjects = selectedToplevelNodes.map(id => nodes.find(s => s.id === id)).filter(shape => shape);
  const selectedPersistentPrimaryNodes = (0, _functional.flatten)(selectedPrimaryShapeObjects.map(shape => nodes.find(n => n.id === shape.id) // is it a leaf or a persisted group?
  ? [shape.id] : nodes.filter(s => s.parent === shape.id).map(s => s.id)));
  const selectedNodeIds = (0, _functional.flatten)(selectedPersistentPrimaryNodes.map((0, _integration_utils.crawlTree)(nodes)));
  return {
    state,
    isEditable: !(0, _app.getFullscreen)(state) && (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state),
    elements: nodes,
    selectedToplevelNodes,
    selectedNodes: selectedNodeIds.map(id => nodes.find(s => s.id === id)),
    pageStyle: (0, _workpad.getPageById)(state, ownProps.pageId).style,
    zoomScale: (0, _app.getZoomScale)(state)
  };
};
const mapDispatchToProps = dispatch => ({
  dispatch,
  insertNodes: (selectedNodes, pageId) => dispatch((0, _elements.insertNodes)(selectedNodes, pageId)),
  removeNodes: (nodeIds, pageId) => dispatch((0, _elements.removeElements)(nodeIds, pageId)),
  selectToplevelNodes: nodes => dispatch((0, _transient.selectToplevelNodes)(nodes.filter(e => !e.position.parent).map(e => e.id))),
  elementLayer: (pageId, elementId, movement) => dispatch((0, _elements.elementLayer)({
    pageId,
    elementId,
    movement
  })),
  setMultiplePositions: pageId => repositionedNodes => dispatch((0, _elements.setMultiplePositions)(repositionedNodes.map(node => ({
    ...node,
    pageId,
    elementId: node.id
  }))))
});
const mergeProps = ({
  state,
  ...restStateProps
}, {
  dispatch,
  ...restDispatchProps
}, ownProps) => ({
  ...ownProps,
  ...restDispatchProps,
  ...restStateProps,
  updateGlobalState: (0, _integration_utils.globalStateUpdater)(dispatch, state),
  setMultiplePositions: restDispatchProps.setMultiplePositions(ownProps.pageId)
});
const InteractivePage = (0, _recompose.compose)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps), (0, _recompose.withState)('aeroStore', 'setAeroStore'), (0, _recompose.withProps)(componentLayoutState), (0, _recompose.withProps)(({
  aeroStore,
  updateGlobalState
}) => ({
  commit: (type, payload) => {
    const newLayoutState = aeroStore.commit(type, payload);
    if (newLayoutState.currentScene.gestureEnd) {
      updateGlobalState(newLayoutState);
    }
  }
})), (0, _recompose.lifecycle)({
  componentWillUnmount() {
    this.props.unregisterLayout(this.props.aeroStore);
  }
}), (0, _recompose.withState)('canvasOrigin', 'saveCanvasOrigin'), (0, _recompose.withState)('_forceRerender', 'forceRerender'), (0, _recompose.withProps)(({
  registerLayout,
  aeroStore,
  updateGlobalState,
  forceRerender
}) => {
  registerLayout((type, payload) => {
    const newLayoutState = aeroStore.commit(type, payload);
    if (newLayoutState.currentScene.gestureEnd) {
      // conditionalizing the global update so as to enable persist-free nudge series
      updateGlobalState(newLayoutState);
    }
    forceRerender(newLayoutState);
    return newLayoutState;
  });
  return {
    cursor: aeroStore.getCurrentState().currentScene.cursor
  };
}), (0, _recompose.withProps)(({
  aeroStore,
  elements
}) => {
  const elementLookup = new Map(elements.map(element => [element.id, element]));
  const elementsToRender = aeroStore.getCurrentState().currentScene.shapes.map(shape => {
    const element = elementLookup.get(shape.id);
    return element ? {
      ...shape,
      width: shape.a * 2,
      height: shape.b * 2,
      filter: element.filter
    } : shape;
  });
  return {
    elements: elementsToRender
  };
}), (0, _recompose.withProps)(({
  commit,
  forceRerender
}) => ({
  commit: (...args) => forceRerender(commit(...args))
})), (0, _recompose.withProps)((...props) => ({
  ...props,
  canDragElement: element => !isEmbeddableBody(element) && !isEuiSelect(element) && isInWorkpad(element)
})), (0, _recompose.withHandlers)(_event_handlers.eventHandlers),
// Captures user intent, needs to have reconciled state
() => _interactive_workpad_page.InteractiveWorkpadPage);
exports.InteractivePage = InteractivePage;