"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopColorPicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDeleteStopColorLabel: () => _i18n.i18n.translate('xpack.canvas.stopsColorPicker.deleteColorStopLabel', {
    defaultMessage: 'Delete'
  })
};
const isValidColorStop = colorStop => {
  const valid = !isNaN(colorStop.stop);
  return {
    valid,
    stop: valid,
    color: true
  };
};
const StopColorPicker = props => {
  const {
    stop,
    color,
    onDelete,
    onChange,
    removable = true
  } = props;
  const [colorStop, setColorStop] = (0, _react.useState)({
    stop: stop !== null && stop !== void 0 ? stop : 0,
    color: color !== null && color !== void 0 ? color : ''
  });
  const [areValidFields, setAreValidFields] = (0, _react.useState)({
    stop: true,
    color: true
  });
  const onChangeInput = updatedColorStop => {
    setColorStop(updatedColorStop);
  };
  const [, cancel] = (0, _useDebounce.default)(() => {
    if (color === colorStop.color && stop === colorStop.stop) {
      return;
    }
    const {
      valid,
      ...validationResult
    } = isValidColorStop(colorStop);
    if (!valid) {
      setAreValidFields(validationResult);
      return;
    }
    onChange(colorStop);
  }, 150, [colorStop]);
  (0, _react.useEffect)(() => {
    const newColorStop = {
      stop: stop !== null && stop !== void 0 ? stop : 0,
      color: color !== null && color !== void 0 ? color : ''
    };
    setColorStop(newColorStop);
    const {
      valid,
      ...validationResult
    } = isValidColorStop(newColorStop);
    setAreValidFields(validationResult);
  }, [color, stop]);
  (0, _react.useEffect)(() => {
    return () => {
      cancel();
    };
  }, [cancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: colorStop.stop,
    min: -Infinity,
    onChange: ({
      target: {
        valueAsNumber
      }
    }) => onChangeInput({
      ...colorStop,
      stop: valueAsNumber
    }),
    isInvalid: !areValidFields.stop
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    secondaryInputDisplay: "top",
    color: colorStop.color,
    showAlpha: true,
    compressed: true,
    onChange: newColor => {
      onChangeInput({
        ...colorStop,
        color: newColor
      });
    },
    isInvalid: !areValidFields.color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    title: strings.getDeleteStopColorLabel(),
    onClick: onDelete,
    isDisabled: !removable,
    "aria-label": strings.getDeleteStopColorLabel()
  })));
};
exports.StopColorPicker = StopColorPicker;