"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Paginate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _paginate = require("./paginate");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Paginate = ({
  perPage = 10,
  startPage = 0,
  rows,
  children
}) => {
  const totalPages = Math.ceil(rows.length / perPage);
  const initialCurrentPage = totalPages > 0 ? Math.min(startPage, totalPages - 1) : 0;
  const [currentPage, setPage] = (0, _react.useState)(initialCurrentPage);
  const hasRenderedRef = (0, _react.useRef)(false);
  const maxPage = Math.max(totalPages - 1, 0);
  const start = currentPage * perPage;
  const end = currentPage === 0 ? perPage : perPage * (currentPage + 1);
  const nextPageEnabled = currentPage < maxPage;
  const prevPageEnabled = currentPage > 0;
  const partialRows = rows.slice(start, end);
  const nextPage = () => {
    if (nextPageEnabled) {
      setPage(currentPage + 1);
    }
  };
  const prevPage = () => {
    if (prevPageEnabled) {
      setPage(currentPage - 1);
    }
  };
  (0, _react.useEffect)(() => {
    if (!hasRenderedRef.current) {
      hasRenderedRef.current = true;
    } else {
      setPage(0);
    }
  }, [perPage, hasRenderedRef]);
  (0, _react.useEffect)(() => {
    if (currentPage > maxPage) {
      setPage(maxPage);
    }
  }, [currentPage, maxPage]);
  return /*#__PURE__*/_react.default.createElement(_paginate.Paginate, {
    rows: partialRows,
    perPage: perPage,
    pageNumber: currentPage,
    totalPages: totalPages,
    setPage: setPage,
    nextPage: nextPage,
    prevPage: prevPage,
    nextPageEnabled: nextPageEnabled,
    prevPageEnabled: prevPageEnabled,
    children: children
  });
};
exports.Paginate = Paginate;
Paginate.propTypes = {
  rows: _propTypes.default.array.isRequired,
  perPage: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  startPage: _propTypes.default.number
};