"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _workpad_page = require("../workpad_page");
var _routing = require("../routing");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const ExportApp = ({
  workpad,
  selectedPageIndex,
  initializeWorkpad
}) => {
  const {
    id,
    pages,
    height,
    width
  } = workpad;
  const activePage = pages[selectedPageIndex];
  const pageElementCount = activePage.elements.length;
  (0, _react.useEffect)(() => initializeWorkpad());
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExport",
    "data-shared-page": selectedPageIndex + 1
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExport__stage"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stageHeader"
  }, /*#__PURE__*/_react.default.createElement(_routing.RoutingLink, {
    to: `/workpad/${id}`
  }, "Edit Workpad")), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)(workpad.css),
    className: "canvasExport__stageContent",
    "data-shared-items-count": pageElementCount
  }, /*#__PURE__*/_react.default.createElement(_workpad_page.WorkpadPage, {
    isSelected: true,
    key: activePage.id,
    pageId: activePage.id,
    height: height,
    width: width,
    registerLayout: () => {},
    unregisterLayout: () => {}
  }))));
};
exports.ExportApp = ExportApp;
ExportApp.propTypes = {
  workpad: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    pages: _propTypes.default.array.isRequired
  }).isRequired,
  selectedPageIndex: _propTypes.default.number.isRequired,
  initializeWorkpad: _propTypes.default.func.isRequired
};