"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BfetchPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _coreHttpCommon = require("@kbn/core-http-common");
var _streaming = require("./streaming");
var _common = require("../common");
var _batching = require("./batching");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class BfetchPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "fetchStreaming", (version, basePath, getIsCompressionDisabled) => params => (0, _streaming.fetchStreaming)({
      ...params,
      url: `${basePath}/${(0, _common.removeLeadingSlash)(params.url)}`,
      headers: {
        'Content-Type': 'application/json',
        'kbn-version': version,
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'Kibana',
        ...(params.headers || {})
      },
      getIsCompressionDisabled
    }));
    (0, _defineProperty2.default)(this, "batchedFunction", (fetchStreaming, getIsCompressionDisabled) => params => (0, _batching.createStreamingBatchedFunction)({
      ...params,
      getIsCompressionDisabled,
      fetchStreaming: params.fetchStreaming || fetchStreaming
    }));
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    const {
      version
    } = this.initializerContext.env.packageInfo;
    const basePath = core.http.basePath.get();
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    const getIsCompressionDisabled = () => startServices().core.uiSettings.get(_common.DISABLE_BFETCH_COMPRESSION);
    const fetchStreaming = this.fetchStreaming(version, basePath, getIsCompressionDisabled);
    const batchedFunction = this.batchedFunction(fetchStreaming, getIsCompressionDisabled);
    this.contract = {
      fetchStreaming,
      batchedFunction
    };
    return this.contract;
  }
  start(core, plugins) {
    return this.contract;
  }
  stop() {}
}
exports.BfetchPublicPlugin = BfetchPublicPlugin;