"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pingRoute = pingRoute;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function pingRoute({
  router
}) {
  router.get({
    path: `${_constants.ASSET_MANAGER_API_BASE}/ping`,
    validate: false
  }, async (_context, _req, res) => {
    return res.ok({
      body: {
        message: 'Asset Manager OK'
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}