"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _ping = require("./ping");
var _assets = require("./assets");
var _sample_assets = require("./sample_assets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupRoutes({
  router
}) {
  (0, _ping.pingRoute)({
    router
  });
  (0, _assets.assetsRoutes)({
    router
  });
  (0, _sample_assets.sampleAssetsRoutes)({
    router
  });
}