"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetNotFoundError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AssetNotFoundError extends Error {
  constructor(ean) {
    super(`Asset with ean (${ean}) not found in the provided time range`);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'AssetNotFoundError';
  }
}
exports.AssetNotFoundError = AssetNotFoundError;