"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServicesWithoutTransactions = getServicesWithoutTransactions;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _service_group_query = require("../../../lib/service_group_query");
var _document_type = require("../../../../common/document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServicesWithoutTransactions({
  environment,
  apmEventClient,
  maxNumServices,
  kuery,
  start,
  end,
  serviceGroup,
  randomSampler,
  documentType,
  rollupInterval
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const isServiceTransactionMetric = documentType === _document_type.ApmDocumentType.ServiceTransactionMetric;
  const response = await apmEventClient.search(isServiceTransactionMetric ? 'get_services_from_service_summary' : 'get_services_from_error_and_metric_documents', {
    apm: isServiceTransactionMetric ? {
      sources: [{
        documentType: _document_type.ApmDocumentType.ServiceSummaryMetric,
        rollupInterval
      }]
    } : {
      events: [_common.ProcessorEvent.metric, _common.ProcessorEvent.error]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _service_group_query.serviceGroupQuery)(serviceGroup)]
        }
      },
      aggs: {
        sample: {
          random_sampler: randomSampler,
          aggs: {
            services: {
              terms: {
                field: _apm.SERVICE_NAME,
                size: maxNumServices
              },
              aggs: {
                environments: {
                  terms: {
                    field: _apm.SERVICE_ENVIRONMENT
                  }
                },
                latest: {
                  top_metrics: {
                    metrics: [{
                      field: _apm.AGENT_NAME
                    }],
                    sort: {
                      '@timestamp': 'desc'
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  });
  return {
    services: (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.sample.services.buckets.map(bucket => {
      return {
        serviceName: bucket.key,
        environments: bucket.environments.buckets.map(envBucket => envBucket.key),
        agentName: bucket.latest.top[0].metrics[_apm.AGENT_NAME]
      };
    })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [],
    maxServiceCountExceeded: ((_response$aggregation3 = (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.sample.services.sum_other_doc_count) !== null && _response$aggregation3 !== void 0 ? _response$aggregation3 : 0) > 0
  };
}