"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diagnosticsRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_apm_indices = require("../settings/apm_indices/get_apm_indices");
var _get_diagnostics_bundle = require("./get_diagnostics_bundle");
var _get_fleet_package_info = require("./get_fleet_package_info");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDiagnosticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/diagnostics',
  options: {
    tags: ['access:apm']
  },
  params: t.partial({
    query: t.partial({
      kuery: t.string,
      start: _ioTsUtils.isoToEpochRt,
      end: _ioTsUtils.isoToEpochRt
    })
  }),
  handler: async resources => {
    const {
      start,
      end,
      kuery
    } = resources.params.query;
    const coreContext = await resources.context.core;
    const {
      asCurrentUser: esClient
    } = coreContext.elasticsearch.client;
    const apmIndices = await (0, _get_apm_indices.getApmIndices)({
      savedObjectsClient: coreContext.savedObjects.client,
      config: resources.config
    });
    const bundle = await (0, _get_diagnostics_bundle.getDiagnosticsBundle)({
      esClient,
      apmIndices,
      start,
      end,
      kuery
    });
    const fleetPackageInfo = await (0, _get_fleet_package_info.getFleetPackageInfo)(resources);
    const kibanaVersion = resources.kibanaVersion;
    return {
      ...bundle,
      fleetPackageInfo,
      kibanaVersion
    };
  }
});
const diagnosticsRepository = {
  ...getDiagnosticsRoute
};
exports.diagnosticsRepository = diagnosticsRepository;