"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiagnosticsBundle = getDiagnosticsBundle;
var _get_data_streams = require("./bundle/get_data_streams");
var _get_non_data_stream_indices = require("./bundle/get_non_data_stream_indices");
var _get_elasticsearch_version = require("./get_elasticsearch_version");
var _get_index_templates_by_index_pattern = require("./bundle/get_index_templates_by_index_pattern");
var _get_existing_index_templates = require("./bundle/get_existing_index_templates");
var _get_indices_states = require("./bundle/get_indices_states");
var _get_apm_events = require("./bundle/get_apm_events");
var _get_apm_index_template_names = require("./helpers/get_apm_index_template_names");
var _handle_403_exception = require("./helpers/handle_403_exception");
var _get_diagnostic_privileges = require("./helpers/get_diagnostic_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFEAULT_START = Date.now() - 60 * 5 * 1000; // 5 minutes
const DEFAULT_END = Date.now();
async function getDiagnosticsBundle({
  esClient,
  apmIndices,
  start = DEFEAULT_START,
  end = DEFAULT_END,
  kuery
}) {
  const diagnosticsPrivileges = await (0, _get_diagnostic_privileges.getDiagnosticsPrivileges)({
    esClient,
    apmIndices
  });
  const indexTemplatesByIndexPattern = await (0, _handle_403_exception.handle403Exception)((0, _get_index_templates_by_index_pattern.getIndexTemplatesByIndexPattern)({
    esClient,
    apmIndices
  }), []);
  const existingIndexTemplates = await (0, _handle_403_exception.handle403Exception)((0, _get_existing_index_templates.getExistingApmIndexTemplates)({
    esClient
  }), []);
  const dataStreams = await (0, _handle_403_exception.handle403Exception)((0, _get_data_streams.getDataStreams)({
    esClient,
    apmIndices
  }), []);
  const nonDataStreamIndices = await (0, _handle_403_exception.handle403Exception)((0, _get_non_data_stream_indices.getNonDataStreamIndices)({
    esClient,
    apmIndices
  }), []);
  const {
    invalidIndices,
    validIndices,
    indices,
    ingestPipelines,
    fieldCaps
  } = await (0, _handle_403_exception.handle403Exception)((0, _get_indices_states.getIndicesStates)({
    esClient,
    apmIndices
  }), {
    invalidIndices: [],
    validIndices: [],
    indices: [],
    ingestPipelines: [],
    fieldCaps: {}
  });
  const apmEvents = await (0, _handle_403_exception.handle403Exception)((0, _get_apm_events.getApmEvents)({
    esClient,
    apmIndices,
    start,
    end,
    kuery
  }), []);
  const elasticsearchVersion = await (0, _handle_403_exception.handle403Exception)((0, _get_elasticsearch_version.getElasticsearchVersion)(esClient), 'N/A');
  return {
    created_at: new Date().toISOString(),
    diagnosticsPrivileges,
    apmIndices,
    elasticsearchVersion,
    esResponses: {
      fieldCaps,
      indices,
      ingestPipelines,
      existingIndexTemplates
    },
    apmIndexTemplates: (0, _get_apm_index_template_names.getApmIndexTemplates)(existingIndexTemplates),
    invalidIndices,
    validIndices,
    indexTemplatesByIndexPattern,
    dataStreams,
    nonDataStreamIndices,
    apmEvents,
    params: {
      start,
      end,
      kuery
    }
  };
}