"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExistingApmIndexTemplates = getExistingApmIndexTemplates;
var _get_apm_index_template_names = require("../helpers/get_apm_index_template_names");
var _get_index_template = require("./get_index_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Check whether the default APM index templates exist
async function getExistingApmIndexTemplates({
  esClient
}) {
  const apmIndexTemplateNames = (0, _get_apm_index_template_names.getApmIndexTemplateNames)();
  const values = await Promise.all(apmIndexTemplateNames.map(async indexTemplateName => {
    const res = await (0, _get_index_template.getIndexTemplate)(esClient, {
      name: indexTemplateName
    });
    return res.index_templates[0];
  }));
  return values.filter(v => v !== undefined);
}