"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.djangoVariables = exports.djangoLineNumbers = exports.djangoHighlightLang = exports.django = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const djangoVariables = {
  apmServiceName: 'SERVICE_NAME',
  secretToken: 'SECRET_TOKEN',
  apmServerUrl: 'SERVER_URL',
  apmEnvironment: 'ENVIRONMENT'
};
exports.djangoVariables = djangoVariables;
const djangoHighlightLang = 'py';
exports.djangoHighlightLang = djangoHighlightLang;
const djangoAddAgentComment = _i18n.i18n.translate('xpack.apm.tutorial.djangoClient.configure.commands.addAgentComment', {
  defaultMessage: 'Add the agent to installed apps'
});
const djangoTracingMiddlewareComment = _i18n.i18n.translate('xpack.apm.tutorial.djangoClient.configure.commands.addTracingMiddlewareComment', {
  defaultMessage: 'Add our tracing middleware to send performance metrics'
});
const djangoLineNumbers = {
  start: 1,
  highlight: '1-4, 7, 9, 11, 13, 16-19',
  annotations: {
    2: djangoAddAgentComment,
    7: _shared_hints.serviceNameHint,
    9: _shared_hints.secretTokenHint,
    11: _shared_hints.serverUrlHint,
    13: _shared_hints.serviceEnvironmentHint,
    17: djangoTracingMiddlewareComment
  }
};
exports.djangoLineNumbers = djangoLineNumbers;
const django = `INSTALLED_APPS = (
  'elasticapm.contrib.django',
  # ...
)

ELASTIC_APM = {
  '${djangoVariables.apmServiceName}': '{{{apmServiceName}}}',

  '${djangoVariables.secretToken}': '{{{secretToken}}}',

  '${djangoVariables.apmServerUrl}': '{{{apmServerUrl}}}',

  '${djangoVariables.apmEnvironment}': '{{{apmEnvironment}}}',
}

MIDDLEWARE = (
  'elasticapm.contrib.django.middleware.TracingMiddleware',
  #...
)`;
exports.django = django;