"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmTimeRangeMetadataContextProvider = ApmTimeRangeMetadataContextProvider;
exports.TimeRangeMetadataContext = void 0;
exports.TimeRangeMetadataContextProvider = TimeRangeMetadataContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_apm_route_path = require("../../hooks/use_apm_route_path");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_time_range = require("../../hooks/use_time_range");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeMetadataContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.TimeRangeMetadataContext = TimeRangeMetadataContext;
function ApmTimeRangeMetadataContextProvider({
  children
}) {
  const {
    core: {
      uiSettings
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const kuery = 'kuery' in query && query.kuery ? query.kuery : '';
  const range = 'rangeFrom' in query && 'rangeTo' in query ? {
    rangeFrom: query.rangeFrom,
    rangeTo: query.rangeTo
  } : undefined;
  if (!range) {
    throw new Error('rangeFrom/rangeTo missing in URL');
  }
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)(range);
  const routePath = (0, _use_apm_route_path.useApmRoutePath)();
  const isOperationView = routePath.startsWith('/dependencies/operation') || routePath.startsWith('/dependencies/operations');
  return /*#__PURE__*/_react.default.createElement(TimeRangeMetadataContextProvider, {
    uiSettings: uiSettings,
    useSpanName: isOperationView,
    start: start,
    end: end,
    kuery: kuery
  }, children);
}
function TimeRangeMetadataContextProvider({
  children,
  uiSettings,
  useSpanName,
  start,
  end,
  kuery
}) {
  const enableServiceTransactionMetrics = uiSettings.get(_common.apmEnableServiceMetrics, true);
  const enableContinuousRollups = uiSettings.get(_common.apmEnableContinuousRollups, true);
  const fetcherResult = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/time_range_metadata', {
      params: {
        query: {
          start,
          end,
          kuery,
          useSpanName,
          enableServiceTransactionMetrics,
          enableContinuousRollups
        }
      }
    });
  }, [start, end, kuery, useSpanName, enableServiceTransactionMetrics, enableContinuousRollups]);
  return /*#__PURE__*/_react.default.createElement(TimeRangeMetadataContext.Provider, {
    value: fetcherResult
  }, children);
}