"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _formatters = require("../../../../common/utils/formatters");
var _get_timeseries_color = require("../charts/helper/get_timeseries_color");
var _impact_bar = require("../impact_bar");
var _transaction_detail_link = require("../links/apm/transaction_detail_link");
var _list_metric = require("../list_metric");
var _get_comparison_options = require("../time_comparison/get_comparison_options");
var _get_latency_column_label = require("./get_latency_column_label");
var _style = require("../../../utils/style");
var _apm = require("../../../../common/es_fields/apm");
var _field_value_pair_to_kql = require("../../../../common/utils/field_value_pair_to_kql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumns({
  serviceName,
  latencyAggregationType,
  transactionGroupDetailedStatisticsLoading,
  transactionGroupDetailedStatistics,
  comparisonEnabled,
  shouldShowSparkPlots = true,
  showAlertsColumn,
  offset,
  transactionOverflowCount,
  link,
  query
}) {
  return [...(showAlertsColumn ? [{
    field: 'alertsCount',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.transactionsTableColumnName.alertsColumnLabel', {
      defaultMessage: 'Active alerts'
    }),
    width: `${_style.unit * 6}px`,
    render: (_, {
      alertsCount,
      name,
      transactionType
    }) => {
      if (!alertsCount) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: _i18n.i18n.translate('xpack.apm.home.transactionsTableColumnName.tooltip.activeAlertsExplanation', {
          defaultMessage: 'Active alerts'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        color: "danger",
        href: link('/services/{serviceName}/alerts', {
          path: {
            serviceName
          },
          query: {
            ...query,
            kuery: [query.kuery, ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.TRANSACTION_NAME, name), ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.TRANSACTION_TYPE, transactionType)].filter(Boolean).join(' and '),
            alertStatus: _technical_rule_data_field_names.ALERT_STATUS_ACTIVE
          }
        })
      }, alertsCount));
    }
  }] : []), {
    field: 'name',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnName', {
      defaultMessage: 'Name'
    }),
    width: '30%',
    render: (_, {
      name,
      transactionType: type
    }) => {
      return /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
        serviceName: serviceName,
        transactionName: name,
        transactionType: type,
        latencyAggregationType: latencyAggregationType,
        comparisonEnabled: comparisonEnabled,
        offset: offset,
        overflowCount: transactionOverflowCount
      }, name);
    }
  }, {
    field: 'latency',
    sortable: true,
    name: (0, _get_latency_column_label.getLatencyColumnLabel)(latencyAggregationType),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      latency,
      name
    }) => {
      var _transactionGroupDeta, _transactionGroupDeta2, _transactionGroupDeta3, _transactionGroupDeta4;
      const currentTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta = transactionGroupDetailedStatistics.currentPeriod) === null || _transactionGroupDeta === void 0 ? void 0 : (_transactionGroupDeta2 = _transactionGroupDeta[name]) === null || _transactionGroupDeta2 === void 0 ? void 0 : _transactionGroupDeta2.latency;
      const previousTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta3 = transactionGroupDetailedStatistics.previousPeriod) === null || _transactionGroupDeta3 === void 0 ? void 0 : (_transactionGroupDeta4 = _transactionGroupDeta3[name]) === null || _transactionGroupDeta4 === void 0 ? void 0 : _transactionGroupDeta4.latency;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: transactionGroupDetailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency),
        comparisonSeriesColor: previousPeriodColor
      });
    }
  }, {
    field: 'throughput',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnThroughput', {
      defaultMessage: 'Throughput'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      throughput,
      name
    }) => {
      var _transactionGroupDeta5, _transactionGroupDeta6, _transactionGroupDeta7, _transactionGroupDeta8;
      const currentTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta5 = transactionGroupDetailedStatistics.currentPeriod) === null || _transactionGroupDeta5 === void 0 ? void 0 : (_transactionGroupDeta6 = _transactionGroupDeta5[name]) === null || _transactionGroupDeta6 === void 0 ? void 0 : _transactionGroupDeta6.throughput;
      const previousTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta7 = transactionGroupDetailedStatistics.previousPeriod) === null || _transactionGroupDeta7 === void 0 ? void 0 : (_transactionGroupDeta8 = _transactionGroupDeta7[name]) === null || _transactionGroupDeta8 === void 0 ? void 0 : _transactionGroupDeta8.throughput;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: transactionGroupDetailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        comparisonSeriesColor: previousPeriodColor
      });
    }
  }, {
    field: 'errorRate',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnErrorRateTip', {
        defaultMessage: "The percentage of failed transactions for the selected service. HTTP server transactions with a 4xx status code (client error) aren't considered failures because the caller, not the server, caused the failure."
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignCenter"
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      errorRate,
      name
    }) => {
      var _transactionGroupDeta9, _transactionGroupDeta10, _transactionGroupDeta11, _transactionGroupDeta12;
      const currentTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta9 = transactionGroupDetailedStatistics.currentPeriod) === null || _transactionGroupDeta9 === void 0 ? void 0 : (_transactionGroupDeta10 = _transactionGroupDeta9[name]) === null || _transactionGroupDeta10 === void 0 ? void 0 : _transactionGroupDeta10.errorRate;
      const previousTimeseries = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta11 = transactionGroupDetailedStatistics.previousPeriod) === null || _transactionGroupDeta11 === void 0 ? void 0 : (_transactionGroupDeta12 = _transactionGroupDeta11[name]) === null || _transactionGroupDeta12 === void 0 ? void 0 : _transactionGroupDeta12.errorRate;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: transactionGroupDetailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asPercent)(errorRate, 1),
        comparisonSeriesColor: previousPeriodColor
      });
    }
  }, {
    field: 'impact',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnImpactTip', {
        defaultMessage: 'The most used and slowest endpoints in your service. Calculated by multiplying latency by throughput.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnImpact', {
      defaultMessage: 'Impact'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignCenter"
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      name
    }) => {
      var _transactionGroupDeta13, _transactionGroupDeta14, _transactionGroupDeta15, _transactionGroupDeta16, _transactionGroupDeta17;
      const currentImpact = (_transactionGroupDeta13 = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta14 = transactionGroupDetailedStatistics.currentPeriod) === null || _transactionGroupDeta14 === void 0 ? void 0 : (_transactionGroupDeta15 = _transactionGroupDeta14[name]) === null || _transactionGroupDeta15 === void 0 ? void 0 : _transactionGroupDeta15.impact) !== null && _transactionGroupDeta13 !== void 0 ? _transactionGroupDeta13 : 0;
      const previousImpact = transactionGroupDetailedStatistics === null || transactionGroupDetailedStatistics === void 0 ? void 0 : (_transactionGroupDeta16 = transactionGroupDetailedStatistics.previousPeriod) === null || _transactionGroupDeta16 === void 0 ? void 0 : (_transactionGroupDeta17 = _transactionGroupDeta16[name]) === null || _transactionGroupDeta17 === void 0 ? void 0 : _transactionGroupDeta17.impact;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "xs",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: currentImpact,
        size: "m"
      })), comparisonEnabled && previousImpact !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: previousImpact,
        size: "s",
        color: "subdued"
      })));
    }
  }];
}