"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionActionMenu = TransactionActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _apm_feature_flags = require("../../../../common/apm_feature_flags");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_license_context = require("../../../context/license/use_license_context");
var _use_apm_feature_flag = require("../../../hooks/use_apm_feature_flag");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _custom_link_menu_section = require("./custom_link_menu_section");
var _sections = require("./sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ActionMenuButton({
  onClick,
  isLoading
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmActionMenuButtonInvestigateButton",
    isLoading: isLoading,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onClick
  }, _i18n.i18n.translate('xpack.apm.transactionActionMenu.actionsButtonLabel', {
    defaultMessage: 'Investigate'
  }));
}
function TransactionActionMenu({
  transaction,
  isLoading
}) {
  const license = (0, _use_license_context.useLicenseContext)();
  const hasGoldLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('gold'));
  const [isActionPopoverOpen, setIsActionPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ActionMenu, {
    id: "transactionActionMenu",
    closePopover: () => setIsActionPopoverOpen(false),
    isOpen: isActionPopoverOpen,
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(ActionMenuButton, {
      isLoading: isLoading,
      onClick: () => setIsActionPopoverOpen(prevIsActionPopoverOpen => !prevIsActionPopoverOpen)
    })
  }, /*#__PURE__*/_react.default.createElement(ActionMenuSections, {
    transaction: transaction
  }), hasGoldLicense && /*#__PURE__*/_react.default.createElement(_custom_link_menu_section.CustomLinkMenuSection, {
    transaction: transaction
  })));
}
function ActionMenuSections({
  transaction
}) {
  var _externalMenuItems$va;
  const {
    core,
    uiActions,
    infra: {
      locators
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const infraLinksAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.InfraUiAvailable);
  const sections = (0, _sections.getSections)({
    transaction,
    basePath: core.http.basePath,
    location,
    apmRouter,
    infraLocators: locators,
    infraLinksAvailable
  });
  const externalMenuItems = (0, _useAsync.default)(() => {
    return transaction ? (0, _public.getContextMenuItemsFromActions)({
      uiActions,
      triggerId: _common.ObservabilityTriggerId.ApmTransactionContextMenu,
      context: transaction
    }) : Promise.resolve([]);
  }, [transaction, uiActions]);
  if ((_externalMenuItems$va = externalMenuItems.value) !== null && _externalMenuItems$va !== void 0 && _externalMenuItems$va.length) {
    sections.push([{
      key: 'external',
      actions: externalMenuItems.value.map((item, i) => {
        return {
          condition: true,
          key: `external-${i}`,
          label: item.children,
          onClick: item.onClick,
          href: item.href
        };
      })
    }]);
  }
  return /*#__PURE__*/_react.default.createElement("div", null, sections.map((section, idx) => {
    const isLastSection = idx !== sections.length - 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx
    }, section.map(item => /*#__PURE__*/_react.default.createElement(_public.Section, {
      key: item.key
    }, item.title && /*#__PURE__*/_react.default.createElement(_public.SectionTitle, null, item.title), item.subtitle && /*#__PURE__*/_react.default.createElement(_public.SectionSubtitle, null, item.subtitle), /*#__PURE__*/_react.default.createElement(_public.SectionLinks, null, item.actions.map(action => /*#__PURE__*/_react.default.createElement(_public.SectionLink, {
      key: action.key,
      label: action.label,
      href: action.href,
      onClick: action.onClick
    }))))), isLastSection && /*#__PURE__*/_react.default.createElement(_public.ActionMenuDivider, null));
  }));
}