"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameHeading = FrameHeading;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _frame_heading_renderers = require("./frame_heading_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDetails = _common.euiStyled.div`
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};
  line-height: 1.5; /* matches the line-hight of the accordion container button */
  padding: 2px 0;
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
`;
const LibraryFrameFileDetail = _common.euiStyled.span`
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};
  word-break: break-word;
`;
const AppFrameFileDetail = _common.euiStyled.span`
  color: ${({
  theme
}) => theme.eui.euiColorFullShade};
  word-break: break-word;
`;
function FrameHeading({
  codeLanguage,
  stackframe,
  isLibraryFrame,
  idx
}) {
  const FileDetail = isLibraryFrame ? LibraryFrameFileDetail : AppFrameFileDetail;
  let Renderer;
  switch (codeLanguage === null || codeLanguage === void 0 ? void 0 : codeLanguage.toString().toLowerCase()) {
    case 'c#':
      Renderer = _frame_heading_renderers.CSharpFrameHeadingRenderer;
      break;
    case 'java':
      Renderer = _frame_heading_renderers.JavaFrameHeadingRenderer;
      break;
    case 'javascript':
      Renderer = _frame_heading_renderers.JavaScriptFrameHeadingRenderer;
      break;
    case 'ruby':
      Renderer = _frame_heading_renderers.RubyFrameHeadingRenderer;
      break;
    case 'php':
      Renderer = _frame_heading_renderers.PhpFrameHeadingRenderer;
      break;
    default:
      Renderer = _frame_heading_renderers.DefaultFrameHeadingRenderer;
      break;
  }
  return /*#__PURE__*/_react.default.createElement(FileDetails, {
    "data-test-subj": "FrameHeading"
  }, /*#__PURE__*/_react.default.createElement(Renderer, {
    fileDetailComponent: FileDetail,
    stackframe: stackframe,
    idx: idx
  }));
}