"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverviewLink = TransactionOverviewLink;
exports.useTransactionsOverviewHref = useTransactionsOverviewHref;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _helpers = require("../../../../context/url_params_context/helpers");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTransactionsOverviewHref({
  serviceName,
  latencyAggregationType,
  transactionType
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    search
  } = location;
  const query = {
    latencyAggregationType,
    transactionType
  };
  return (0, _apm_link.getLegacyApmHref)({
    basePath: core.http.basePath,
    path: `/services/${serviceName}/transactions`,
    query: (0, _helpers.removeUndefinedProps)(query),
    search
  });
}
function TransactionOverviewLink({
  serviceName,
  latencyAggregationType,
  transactionType,
  ...rest
}) {
  const href = useTransactionsOverviewHref({
    serviceName,
    latencyAggregationType,
    transactionType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmTransactionOverviewLinkLink",
    href: href
  }, rest));
}