"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EQLCodeEditor = EQLCodeEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("brace/ext/language_tools");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _completer = require("./completer");
var _constants = require("./constants");
var _eql_mode = require("./eql_mode");
require("./theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EQLCodeEditor(props) {
  const {
    showGutter = false,
    setOptions,
    getSuggestions,
    ...restProps
  } = props;
  const completer = (0, _react.useRef)(new _completer.EQLCodeEditorCompleter());
  const eqlMode = (0, _react.useRef)(new _eql_mode.EQLMode());
  completer.current.setSuggestionCb(getSuggestions);
  const options = {
    enableBasicAutocompletion: true,
    enableLiveAutocompletion: true,
    wrap: true,
    ...setOptions
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "euiTextArea",
    style: {
      maxWidth: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_public.EuiCodeEditor, (0, _extends2.default)({
    showGutter: showGutter,
    mode: eqlMode.current,
    theme: (0, _lodash.last)(_constants.EQL_THEME_NAME.split('/')),
    setOptions: options,
    onAceEditorRef: editor => {
      if (editor) {
        editor.editor.completers = [completer.current];
      }
    }
  }, restProps)));
}