"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Indicator = void 0;
exports.Legend = Legend;
exports.Shape = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_theme = require("../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Shape;
exports.Shape = Shape;
(function (Shape) {
  Shape["circle"] = "circle";
  Shape["square"] = "square";
})(Shape || (exports.Shape = Shape = {}));
const Container = _common.euiStyled.div`
  display: flex;
  align-items: center;
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};
  cursor: ${props => props.clickable ? 'pointer' : 'initial'};
  opacity: ${props => props.disabled ? 0.4 : 1};
  user-select: none;
`;
const radius = 11;
const Indicator = _common.euiStyled.span`
  width: ${radius}px;
  height: ${radius}px;
  margin-right: ${props => props.withMargin ? `${radius / 2}px` : 0};
  background: ${props => props.color};
  border-radius: ${props => {
  return props.shape === Shape.circle ? '100%' : '0';
}};
`;
exports.Indicator = Indicator;
function Legend({
  onClick,
  text,
  color,
  disabled = false,
  clickable = false,
  shape = Shape.circle,
  indicator,
  ...rest
}) {
  const theme = (0, _use_theme.useTheme)();
  const indicatorColor = color || theme.eui.euiColorVis1;
  return /*#__PURE__*/_react.default.createElement(Container, (0, _extends2.default)({
    onClick: onClick,
    disabled: disabled,
    clickable: clickable || Boolean(onClick)
  }, rest), indicator ? indicator : /*#__PURE__*/_react.default.createElement(Indicator, {
    color: indicatorColor,
    shape: shape,
    withMargin: !!text
  }), text);
}