"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentIcon = getAgentIcon;
exports.getAgentIconKey = getAgentIconKey;
var _agent_name = require("../../../../common/agent_name");
var _default = _interopRequireDefault(require("../span_icon/icons/default.svg"));
var _cpp = _interopRequireDefault(require("./icons/cpp.svg"));
var _cpp_dark = _interopRequireDefault(require("./icons/cpp_dark.svg"));
var _dot_net = _interopRequireDefault(require("./icons/dot_net.svg"));
var _erlang = _interopRequireDefault(require("./icons/erlang.svg"));
var _erlang_dark = _interopRequireDefault(require("./icons/erlang_dark.svg"));
var _go = _interopRequireDefault(require("./icons/go.svg"));
var _ios = _interopRequireDefault(require("./icons/ios.svg"));
var _ios_dark = _interopRequireDefault(require("./icons/ios_dark.svg"));
var _java = _interopRequireDefault(require("./icons/java.svg"));
var _nodejs = _interopRequireDefault(require("./icons/nodejs.svg"));
var _ocaml = _interopRequireDefault(require("./icons/ocaml.svg"));
var _otel_default = _interopRequireDefault(require("./icons/otel_default.svg"));
var _php = _interopRequireDefault(require("./icons/php.svg"));
var _python = _interopRequireDefault(require("./icons/python.svg"));
var _ruby = _interopRequireDefault(require("./icons/ruby.svg"));
var _rumjs = _interopRequireDefault(require("./icons/rumjs.svg"));
var _php_dark = _interopRequireDefault(require("./icons/php_dark.svg"));
var _rumjs_dark = _interopRequireDefault(require("./icons/rumjs_dark.svg"));
var _rust = _interopRequireDefault(require("./icons/rust.svg"));
var _rust_dark = _interopRequireDefault(require("./icons/rust_dark.svg"));
var _android = _interopRequireDefault(require("./icons/android.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentIcons = {
  cpp: _cpp.default,
  dotnet: _dot_net.default,
  erlang: _erlang.default,
  go: _go.default,
  ios: _ios.default,
  java: _java.default,
  nodejs: _nodejs.default,
  ocaml: _ocaml.default,
  opentelemetry: _otel_default.default,
  php: _php.default,
  python: _python.default,
  ruby: _ruby.default,
  rum: _rumjs.default,
  rust: _rust.default,
  android: _android.default
};
const darkAgentIcons = {
  ...agentIcons,
  cpp: _cpp_dark.default,
  erlang: _erlang_dark.default,
  ios: _ios_dark.default,
  php: _php_dark.default,
  rum: _rumjs_dark.default,
  rust: _rust_dark.default
};

// This only needs to be exported for testing purposes, since we stub the SVG
// import values in test.
function getAgentIconKey(agentName) {
  // Ignore case
  const lowercasedAgentName = agentName.toLowerCase();

  // RUM agent names
  if ((0, _agent_name.isRumAgentName)(lowercasedAgentName)) {
    return 'rum';
  }

  // Java  agent names
  if ((0, _agent_name.isJavaAgentName)(lowercasedAgentName)) {
    return 'java';
  }
  if ((0, _agent_name.isIosAgentName)(lowercasedAgentName)) {
    return 'ios';
  }
  if ((0, _agent_name.isAndroidAgentName)(lowercasedAgentName)) {
    return 'android';
  }

  // Remove "opentelemetry/" prefix
  const agentNameWithoutPrefix = lowercasedAgentName.replace(/^opentelemetry\//, '');
  if (Object.keys(agentIcons).includes(agentNameWithoutPrefix)) {
    return agentNameWithoutPrefix;
  }

  // OpenTelemetry-only agents
  if (_agent_name.OPEN_TELEMETRY_AGENT_NAMES.includes(lowercasedAgentName)) {
    return 'opentelemetry';
  }
}
function getAgentIcon(agentName, isDarkMode) {
  var _ref;
  const key = agentName && getAgentIconKey(agentName);
  if (!key) {
    return _default.default;
  }
  return (_ref = isDarkMode ? darkAgentIcons[key] : agentIcons[key]) !== null && _ref !== void 0 ? _ref : _default.default;
}