"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverview = TransactionOverview;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _agent_name = require("../../../../common/agent_name");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _use_time_range = require("../../../hooks/use_time_range");
var _aggregated_transactions_badge = require("../../shared/aggregated_transactions_badge");
var _transaction_charts = require("../../shared/charts/transaction_charts");
var _url_helpers = require("../../shared/links/url_helpers");
var _slo_callout = require("../../shared/slo_callout");
var _transactions_table = require("../../shared/transactions_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionOverview() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      transactionType: transactionTypeFromUrl,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/transactions');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    transactionType,
    fallbackToTransactions,
    serverlessType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const history = (0, _reactRouterDom.useHistory)();

  // redirect to first transaction type
  if (!transactionTypeFromUrl && transactionType) {
    (0, _url_helpers.replace)(history, {
      query: {
        transactionType
      }
    });
  }
  const isServerless = (0, _agent_name.isServerlessAgent)(serverlessType);
  const [sloCalloutDismissed, setSloCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.sloCalloutDismissed', false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !sloCalloutDismissed && /*#__PURE__*/_react.default.createElement(_slo_callout.SloCallout, {
    dismissCallout: () => {
      setSloCalloutDismissed(true);
    },
    serviceName: serviceName,
    environment: environment,
    transactionType: transactionType
  }), fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_transaction_charts.TransactionCharts, {
    serviceName: serviceName,
    kuery: kuery,
    environment: environment,
    start: start,
    end: end,
    isServerlessContext: isServerless,
    comparisonEnabled: comparisonEnabled,
    offset: offset
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    hideViewTransactionsLink: true,
    numberOfTransactionsPerPage: 25,
    showMaxTransactionGroupsExceededWarning: true,
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    saveTableOptionsToUrl: true
  })));
}