"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Waterfall = Waterfall;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _timeline = require("../../../../../shared/charts/timeline");
var _url_helpers = require("../../../../../shared/links/url_helpers");
var _get_agent_marks = require("../marks/get_agent_marks");
var _get_error_marks = require("../marks/get_error_marks");
var _accordion_waterfall = require("./accordion_waterfall");
var _waterfall_flyout = require("./waterfall_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _common.euiStyled.div`
  transition: 0.1s padding ease;
  position: relative;
  overflow: hidden;
`;
const toggleFlyout = ({
  history,
  item,
  flyoutDetailTab
}) => {
  history.replace({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(location.search),
      flyoutDetailTab,
      waterfallItemId: item === null || item === void 0 ? void 0 : item.id
    })
  });
};
const WaterfallItemsContainer = _common.euiStyled.div`
  border-bottom: 1px solid ${({
  theme
}) => theme.eui.euiColorMediumShade};
`;
function getWaterfallMaxLevel(waterfall) {
  var _waterfall$entryWater;
  const entryId = (_waterfall$entryWater = waterfall.entryWaterfallTransaction) === null || _waterfall$entryWater === void 0 ? void 0 : _waterfall$entryWater.id;
  if (!entryId) {
    return 0;
  }
  let maxLevel = 1;
  function countLevels(id, currentLevel) {
    const children = waterfall.childrenByParentId[id] || [];
    if (children.length) {
      children.forEach(child => {
        countLevels(child.id, currentLevel + 1);
      });
    } else {
      if (maxLevel < currentLevel) {
        maxLevel = currentLevel;
      }
    }
  }
  countLevels(entryId, 1);
  return maxLevel;
}
// level starts with 0
const maxLevelOpen = 2;
function Waterfall({
  waterfall,
  waterfallItemId,
  showCriticalPath
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const [isAccordionOpen, setIsAccordionOpen] = (0, _react.useState)(true);
  const itemContainerHeight = 58; // TODO: This is a nasty way to calculate the height of the svg element. A better approach should be found
  const waterfallHeight = itemContainerHeight * waterfall.items.length;
  const {
    duration
  } = waterfall;
  const agentMarks = (0, _get_agent_marks.getAgentMarks)(waterfall.entryTransaction);
  const errorMarks = (0, _get_error_marks.getErrorMarks)(waterfall.errorItems);
  const timelineMargins = (0, _react.useMemo)(() => {
    // Calculate the left margin relative to the deepest level, or 100px, whichever
    // is more.
    const maxLevel = getWaterfallMaxLevel(waterfall);
    return {
      top: 40,
      left: Math.max(100, maxLevel * 10),
      right: 50,
      bottom: 0
    };
  }, [waterfall]);
  return /*#__PURE__*/_react.default.createElement(Container, null, waterfall.exceedsMax && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.apm.waterfall.exceedsMax', {
      defaultMessage: 'The number of items in this trace is {traceItemCount} which is higher than the current limit of {maxTraceItems}. Please increase the limit to see the full trace',
      values: {
        traceItemCount: waterfall.traceItemCount,
        maxTraceItems: waterfall.maxTraceItems
      }
    })
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmWaterfallButton",
    style: {
      zIndex: 3,
      position: 'absolute'
    },
    iconType: isAccordionOpen ? 'fold' : 'unfold',
    onClick: () => {
      setIsAccordionOpen(isOpen => !isOpen);
    }
  }), /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    marks: [...agentMarks, ...errorMarks],
    xMax: duration,
    height: waterfallHeight,
    margins: timelineMargins
  })), /*#__PURE__*/_react.default.createElement(WaterfallItemsContainer, null, !waterfall.entryWaterfallTransaction ? null : /*#__PURE__*/_react.default.createElement(_accordion_waterfall.AccordionWaterfall
  // used to recreate the entire tree when `isAccordionOpen` changes, collapsing or expanding all elements.
  , {
    key: `accordion_state_${isAccordionOpen}`,
    isOpen: isAccordionOpen,
    item: waterfall.entryWaterfallTransaction,
    level: 0,
    waterfallItemId: waterfallItemId,
    duration: duration,
    waterfall: waterfall,
    timelineMargins: timelineMargins,
    onClickWaterfallItem: (item, flyoutDetailTab) => toggleFlyout({
      history,
      item,
      flyoutDetailTab
    }),
    showCriticalPath: showCriticalPath,
    maxLevelOpen: waterfall.traceItemCount > 500 ? maxLevelOpen : waterfall.traceItemCount
  }))), /*#__PURE__*/_react.default.createElement(_waterfall_flyout.WaterfallFlyout, {
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    toggleFlyout: toggleFlyout
  }));
}