"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaterfallFetcher = useWaterfallFetcher;
var _react = require("react");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _waterfall_helpers = require("./waterfall_with_summary/waterfall_container/waterfall/waterfall_helpers/waterfall_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DATA = {
  traceItems: {
    errorDocs: [],
    traceDocs: [],
    exceedsMax: false,
    spanLinksCountById: {},
    traceItemCount: 0,
    maxTraceItems: 0
  },
  entryTransaction: undefined
};
function useWaterfallFetcher({
  traceId,
  transactionId,
  start,
  end
}) {
  const {
    data = INITIAL_DATA,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (traceId && start && end && transactionId) {
      return callApmApi('GET /internal/apm/traces/{traceId}', {
        params: {
          path: {
            traceId
          },
          query: {
            start,
            end,
            entryTransactionId: transactionId
          }
        }
      });
    }
  }, [traceId, start, end, transactionId]);
  const waterfall = (0, _react.useMemo)(() => (0, _waterfall_helpers.getWaterfall)(data), [data]);
  return {
    waterfall,
    status,
    error
  };
}