"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageDetailsPerService = StorageDetailsPerService;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-plugin/common");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_progressive_fetcher = require("../../../../hooks/use_progressive_fetcher");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _formatters = require("../../../../../common/utils/formatters/formatters");
var _i18n2 = require("../../../../../common/i18n");
var _formatters2 = require("../../../../../common/utils/formatters");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _size_label = require("./size_label");
var _index_stats_per_service = require("./index_stats_per_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorEventLabelMap = {
  [_common.ProcessorEvent.transaction]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.transactions', {
    defaultMessage: 'Transactions'
  }),
  [_common.ProcessorEvent.span]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.spans', {
    defaultMessage: 'Spans'
  }),
  [_common.ProcessorEvent.metric]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.metrics', {
    defaultMessage: 'Metrics'
  }),
  [_common.ProcessorEvent.error]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.errors', {
    defaultMessage: 'Errors'
  })
};
function StorageDetailsPerService({
  serviceName,
  indexLifecyclePhase
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const chartTheme = (0, _public.useChartTheme)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    environment,
    kuery,
    comparisonEnabled: urlComparisonEnabled
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const serviceOverviewLink = router.link('/services/{serviceName}/overview', {
    path: {
      serviceName
    },
    query: {
      ...query,
      serviceGroup: '',
      comparisonEnabled: (0, _get_comparison_enabled.getComparisonEnabled)({
        core,
        urlComparisonEnabled
      })
    }
  });
  const groupedPalette = (0, _eui.euiPaletteColorBlind)();
  const {
    data,
    status
  } = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/storage_details', {
      params: {
        path: {
          serviceName
        },
        query: {
          indexLifecyclePhase,
          start,
          end,
          environment,
          kuery
        }
      }
    });
  }, [indexLifecyclePhase, start, end, environment, kuery, serviceName]);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '50%'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      "data-test-subj": "loadingSpinner"
    }));
  }
  if (!data || !data.processorEventStats) {
    return null;
  }
  const processorEventStats = data.processorEventStats.map(({
    processorEvent,
    docs,
    size
  }) => ({
    processorEventLabel: ProcessorEventLabelMap[processorEvent],
    docs,
    size
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.title', {
    defaultMessage: 'Service storage details'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmStorageDetailsPerServiceGoToServiceOverviewLink",
    href: serviceOverviewLink
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.serviceOverviewLink', {
    defaultMessage: 'Go to service overview'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "serviceStorageDetailsChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [{
      partition: {
        fillLabel: {
          textColor: euiTheme.colors.emptyShade
        },
        emptySizeRatio: 0.3
      }
    }, ...chartTheme],
    showLegend: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    layout: _charts.PartitionLayout.sunburst,
    id: "storageExplorerSizeByProcessorType",
    data: processorEventStats,
    valueAccessor: d => {
      var _d$size;
      return (_d$size = d.size) !== null && _d$size !== void 0 ? _d$size : 0;
    },
    valueGetter: "percent",
    valueFormatter: d => (0, _formatters2.asDynamicBytes)(d) || _i18n2.NOT_AVAILABLE_LABEL,
    layers: [{
      groupByRollup: d => d.processorEventLabel,
      shape: {
        fillColor: (dataName, sortIndex) => groupedPalette[sortIndex]
      }
    }]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    "data-test-subj": "serviceStorageDetailsTable"
  }, processorEventStats.map(({
    processorEventLabel,
    docs,
    size
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    css: (0, _react2.css)`
                          font-weight: ${euiTheme.font.weight.semiBold};
                        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, processorEventLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_size_label.SizeLabel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    css: (0, _react2.css)`
                          background-color: ${euiTheme.colors.lightestShade};
                          border-top: 1px solid ${euiTheme.colors.lightShade};
                          border-bottom: 1px solid ${euiTheme.colors.lightShade};
                        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (0, _formatters.asInteger)(docs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (0, _formatters2.asDynamicBytes)(size))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_stats_per_service.IndexStatsPerService, {
    indicesStats: data.indicesStats,
    status: status
  }))));
}