"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = SettingsPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _all_option = require("../../../../../../../common/agent_configuration/all_option");
var _setting_definitions = require("../../../../../../../common/agent_configuration/setting_definitions");
var _use_apm_plugin_context = require("../../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../../../hooks/use_fetcher");
var _bottom_bar_actions = require("../../../bottom_bar_actions");
var _save_config = require("./save_config");
var _setting_form_row = require("./setting_form_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function removeEmpty(obj) {
  return Object.fromEntries(Object.entries(obj).filter(([_, v]) => v != null && v !== ''));
}
function SettingsPage({
  status,
  unsavedChanges,
  newConfig,
  setNewConfig,
  resetSettings,
  isEditMode,
  onClickEdit
}) {
  const history = (0, _reactRouterDom.useHistory)();
  // get a telemetry UI event tracker
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const unsavedChangesCount = Object.keys(unsavedChanges).length;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isFormValid = (0, _react.useMemo)(() => {
    return _setting_definitions.settingDefinitions
    // only validate settings that are not empty
    .filter(({
      key
    }) => {
      const value = newConfig.settings[key];
      return value != null && value !== '';
    })

    // every setting must be valid for the form to be valid
    .every(def => {
      const value = newConfig.settings[def.key];
      return (0, _setting_definitions.validateSetting)(def, value).isValid;
    });
  }, [newConfig.settings]);
  const handleSubmitEvent = async () => {
    trackApmEvent({
      metric: 'save_agent_configuration'
    });
    const config = {
      ...newConfig,
      settings: removeEmpty(newConfig.settings)
    };
    setIsSaving(true);
    await (0, _save_config.saveConfig)({
      config,
      isEditMode,
      toasts
    });
    setIsSaving(false);

    // go back to overview
    history.push({
      pathname: '/settings/agent-configuration',
      search: history.location.search
    });
  };
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.notFound.title', {
        defaultMessage: 'Sorry, there was an error'
      }),
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.notFound.message', {
      defaultMessage: 'The requested configuration does not exist'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement("form", {
    onKeyPress: e => {
      const didClickEnter = e.which === 13;
      if (didClickEnter && isFormValid) {
        e.preventDefault();
        handleSubmitEvent();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: isLoading ? '-' : (0, _all_option.getOptionLabel)(newConfig.service.name),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.service.name.label', {
      defaultMessage: 'Service name'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: isLoading ? '-' : (0, _all_option.getOptionLabel)(newConfig.service.environment),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.service.environment.label', {
      defaultMessage: 'Environment'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSettingsPageEditButton",
    onClick: onClickEdit,
    iconType: "pencil"
  }, _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.editButton', {
    defaultMessage: 'Edit'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })) : renderSettings({
    unsavedChanges,
    newConfig,
    setNewConfig
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), unsavedChangesCount > 0 && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: resetSettings,
    onSave: handleSubmitEvent,
    saveLabel: _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.saveButton', {
      defaultMessage: 'Save configuration'
    }),
    unsavedChangesCount: unsavedChangesCount
  }));
}
function renderSettings({
  newConfig,
  unsavedChanges,
  setNewConfig
}) {
  return _setting_definitions.settingDefinitions

  // filter out agent specific items that are not applicable
  // to the selected service
  .filter((0, _setting_definitions.filterByAgent)(newConfig.agent_name)).map(setting => /*#__PURE__*/_react.default.createElement(_setting_form_row.SettingFormRow, {
    isUnsaved: unsavedChanges.hasOwnProperty(setting.key),
    key: setting.key,
    setting: setting,
    value: newConfig.settings[setting.key],
    onChange: (key, value) => {
      setNewConfig(prev => ({
        ...prev,
        settings: {
          ...prev.settings,
          [key]: value
        }
      }));
    }
  }));
}