"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicePage = ServicePage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _all_option = require("../../../../../../../common/agent_configuration/all_option");
var _use_fetcher = require("../../../../../../hooks/use_fetcher");
var _form_row_select = require("./form_row_select");
var _apm_link = require("../../../../../shared/links/apm/apm_link");
var _form_row_suggestions_select = require("./form_row_suggestions_select");
var _apm = require("../../../../../../../common/es_fields/apm");
var _agent_name = require("../../../../../../../common/agent_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServicePage({
  newConfig,
  setNewConfig,
  onClickNext
}) {
  var _environmentsData$env;
  const {
    data: environmentsData,
    status: environmentsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (newConfig.service.name) {
      return callApmApi('GET /api/apm/settings/agent-configuration/environments 2023-10-31', {
        params: {
          query: {
            serviceName: (0, _all_option.omitAllOption)(newConfig.service.name)
          }
        }
      });
    }
  }, [newConfig.service.name], {
    preservePreviousData: false
  });
  const environments = (_environmentsData$env = environmentsData === null || environmentsData === void 0 ? void 0 : environmentsData.environments) !== null && _environmentsData$env !== void 0 ? _environmentsData$env : [];
  const {
    status: agentNameStatus
  } = (0, _use_fetcher.useFetcher)(async callApmApi => {
    const serviceName = newConfig.service.name;
    if (!(0, _lodash.isString)(serviceName) || serviceName.length === 0) {
      return;
    }
    const {
      agentName
    } = await callApmApi('GET /api/apm/settings/agent-configuration/agent_name 2023-10-31', {
      params: {
        query: {
          serviceName
        }
      }
    });
    setNewConfig(prev => ({
      ...prev,
      agent_name: agentName
    }));
  }, [newConfig.service.name, setNewConfig]);
  const ALREADY_CONFIGURED_TRANSLATED = _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.alreadyConfiguredOption', {
    defaultMessage: 'already configured'
  });
  const environmentOptions = environments.map(({
    name,
    alreadyConfigured
  }) => ({
    disabled: alreadyConfigured,
    label: `${(0, _all_option.getOptionLabel)(name)} ${alreadyConfigured ? `(${ALREADY_CONFIGURED_TRANSLATED})` : ''}`,
    value: name
  }));
  const isAgentConfigurationSupported = !newConfig.agent_name || newConfig.agent_name && !(0, _agent_name.isOpenTelemetryAgentName)(newConfig.agent_name);
  const INCORRECT_SERVICE_NAME_TRANSLATED = _i18n.i18n.translate('xpack.apm.settings.agentConfiguration.service.otel.error', {
    defaultMessage: 'Selected service uses an OpenTelemetry agent, which is not supported'
  });
  const isAllOptionSelected = newConfig.service.name === _all_option.ALL_OPTION_VALUE;
  const isSaveButtonDisabled = !newConfig.service.name || !newConfig.service.environment || agentNameStatus === _use_fetcher.FETCH_STATUS.LOADING || !isAgentConfigurationSupported;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form_row_suggestions_select.FormRowSuggestionsSelect, {
    title: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.service.title', {
      defaultMessage: 'Service'
    }),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.service.description', {
      defaultMessage: 'Choose the service you want to configure.'
    }),
    fieldLabel: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.service.fieldLabel', {
      defaultMessage: 'Service name'
    }),
    fieldName: _apm.SERVICE_NAME,
    value: newConfig.service.name,
    onChange: name => {
      setNewConfig(prev => ({
        ...prev,
        service: {
          name,
          environment: ''
        }
      }));
    },
    dataTestSubj: "serviceNameComboBox",
    isInvalid: !isAgentConfigurationSupported,
    error: INCORRECT_SERVICE_NAME_TRANSLATED
  }), isAllOptionSelected && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.apm.settings.agentConfiguration.all.option.calloutTitle', {
      defaultMessage: 'This configuration change will impact all services, except those that use an OpenTelemetry agent. '
    })
  }), /*#__PURE__*/_react.default.createElement(_form_row_select.FormRowSelect, {
    title: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.environment.title', {
      defaultMessage: 'Environment'
    }),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.environment.description', {
      defaultMessage: 'Only a single environment per configuration is supported.'
    }),
    fieldLabel: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.environment.fieldLabel', {
      defaultMessage: 'Service environment'
    }),
    isLoading: environmentsStatus === _use_fetcher.FETCH_STATUS.LOADING,
    options: environmentOptions,
    value: newConfig.service.environment,
    isDisabled: !newConfig.service.name || environmentsStatus === _use_fetcher.FETCH_STATUS.LOADING,
    onChange: environment => {
      setNewConfig(prev => ({
        ...prev,
        service: {
          name: prev.service.name,
          environment
        }
      }));
    },
    dataTestSubj: "serviceEnviromentComboBox"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_apm_link.LegacyAPMLink, {
    path: "/settings/agent-configuration"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmServicePageCancelButton",
    color: "primary"
  }, _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.cancelButton', {
    defaultMessage: 'Cancel'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmServicePageNextStepButton",
    type: "submit",
    fill: true,
    onClick: onClickNext,
    isLoading: agentNameStatus === _use_fetcher.FETCH_STATUS.LOADING,
    isDisabled: isSaveButtonDisabled
  }, _i18n.i18n.translate('xpack.apm.agentConfig.saveConfigurationButtonLabel', {
    defaultMessage: 'Next step'
  })))));
}