"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupSaveButton = ServiceGroupSaveButton;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_button = require("./create_button");
var _edit_button = require("./edit_button");
var _save_modal = require("./save_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceGroupSaveButton() {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    query: {
      serviceGroup
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-groups', '/services', '/service-map');
  const isGroupEditMode = !!serviceGroup;
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (isGroupEditMode) {
      return callApmApi('GET /internal/apm/service-group', {
        params: {
          query: {
            serviceGroup
          }
        }
      });
    }
  }, [serviceGroup, isGroupEditMode]);
  const savedServiceGroup = data === null || data === void 0 ? void 0 : data.serviceGroup;
  function onClick() {
    setIsModalVisible(state => !state);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGroupEditMode ? /*#__PURE__*/_react.default.createElement(_edit_button.EditButton, {
    onClick: onClick
  }) : /*#__PURE__*/_react.default.createElement(_create_button.CreateButton, {
    onClick: onClick
  }), isModalVisible && /*#__PURE__*/_react.default.createElement(_save_modal.SaveGroupModal, {
    savedServiceGroup: savedServiceGroup,
    onClose: () => {
      setIsModalVisible(false);
    }
  }));
}