"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionsSet = InstructionsSet;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _instruction_variants = require("./instruction_variants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTabs(variants) {
  return variants.map(variant => ({
    id: variant.id,
    text: (0, _instruction_variants.getDisplayText)(variant.id)
  }));
}
function InstructionsSet({
  instructions
}) {
  const tabs = getTabs(instructions.instructionVariants);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(tabs[0].id);
  const onSelectedTabChange = tab => {
    setSelectedTab(tab);
  };
  function InstructionTabs({
    agentTabs
  }) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, agentTabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.id,
      isSelected: tab.id === selectedTab,
      onClick: () => onSelectedTabChange(tab.id)
    }, tab.text)));
  }
  function InstructionSteps({
    instructionVariants,
    tab
  }) {
    const selectInstructionSteps = instructionVariants.find(variant => {
      return variant.id === tab;
    });
    if (!selectInstructionSteps) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
      titleSize: "xs",
      steps: selectInstructionSteps.instructions
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(InstructionTabs, {
    agentTabs: tabs
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, instructions.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(InstructionSteps, {
    instructionVariants: instructions.instructionVariants,
    tab: selectedTab
  })));
}