"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _common = require("@kbn/maps-plugin/common");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_layer_list = require("./map_layers/get_layer_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddedMapComponent({
  selectedMap,
  start,
  end,
  kuery = '',
  filters
}) {
  const [error, setError] = (0, _react.useState)();
  const [embeddable, setEmbeddable] = (0, _react.useState)();
  const embeddableRoot = (0, _react.useRef)(null);
  const {
    embeddable: embeddablePlugin,
    maps,
    notifications
  } = (0, _public2.useKibana)().services;
  (0, _react.useEffect)(() => {
    async function setupEmbeddable() {
      const factory = embeddablePlugin === null || embeddablePlugin === void 0 ? void 0 : embeddablePlugin.getEmbeddableFactory(_common.MAP_SAVED_OBJECT_TYPE);
      if (!factory) {
        setError(true);
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.error.toastTitle', {
            defaultMessage: 'An error occurred when adding map embeddable'
          }),
          text: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.error.toastDescription', {
            defaultMessage: `Embeddable factory with id "{embeddableFactoryId}" was not found.`,
            values: {
              embeddableFactoryId: _common.MAP_SAVED_OBJECT_TYPE
            }
          })
        });
        return;
      }
      const input = {
        attributes: {
          title: ''
        },
        id: (0, _uuid.v4)(),
        title: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.input.title', {
          defaultMessage: 'Latency by country'
        }),
        filters,
        viewMode: _public.ViewMode.VIEW,
        mapCenter: {
          lat: 20.43425,
          lon: 0,
          zoom: 1.25
        },
        isLayerTOCOpen: false,
        query: {
          query: kuery,
          language: 'kuery'
        },
        timeRange: {
          from: start,
          to: end
        },
        hideFilterActions: true
      };
      const embeddableObject = await factory.create(input);
      setEmbeddable(embeddableObject);
    }
    setupEmbeddable();
    // Set up exactly once after the component mounts
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // We can only render after embeddable has already initialized
  (0, _react.useEffect)(() => {
    if (embeddableRoot.current && embeddable) {
      embeddable.render(embeddableRoot.current);
    }
  }, [embeddable, embeddableRoot]);
  (0, _react.useEffect)(() => {
    const setLayerList = async () => {
      if (embeddable && !(0, _public.isErrorEmbeddable)(embeddable)) {
        const layerList = await (0, _get_layer_list.getLayerList)({
          selectedMap,
          maps
        });
        await Promise.all([embeddable.setLayerList(layerList), embeddable.reload()]);
      }
    };
    setLayerList();
  }, [embeddable, selectedMap, maps]);
  (0, _react.useEffect)(() => {
    if (embeddable) {
      embeddable.updateInput({
        filters,
        query: {
          query: kuery,
          language: 'kuery'
        },
        timeRange: {
          from: start,
          to: end
        }
      });
    }
  }, [start, end, kuery, filters, embeddable, selectedMap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.error', {
    defaultMessage: 'Could not load map'
  }))), !error && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "serviceOverviewEmbeddedMap",
    css: (0, _react2.css)`
            width: 100%;
            height: 500px;
            display: flex;
            flex: 1 1 100%;
            z-index: 1;
            min-height: 0;
          `,
    ref: embeddableRoot
  }));
}
EmbeddedMapComponent.displayName = 'EmbeddedMap';
const EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);
exports.EmbeddedMap = EmbeddedMap;