"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsApmDocuments = DiagnosticsApmDocuments;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _formatters = require("../../../../common/utils/formatters");
var _data_view_constants = require("../../../../common/data_view_constants");
var _use_diagnostics = require("./context/use_diagnostics");
var _search_bar = require("../../shared/search_bar/search_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsApmDocuments() {
  var _diagnosticsBundle$pa;
  const {
    diagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const {
    discover
  } = (0, _public.useKibana)().services;
  const [sortField, setSortField] = (0, _react.useState)('name');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/diagnostics/documents');
  const items = (0, _react.useMemo)(() => {
    var _diagnosticsBundle$ap;
    return (_diagnosticsBundle$ap = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmEvents.filter(({
      legacy,
      docCount,
      intervals
    }) => {
      const isLegacyAndUnused = legacy === true && docCount === 0 && intervals && Object.values(intervals).every(interval => interval.eventDocCount === 0);
      return !isLegacyAndUnused;
    })) !== null && _diagnosticsBundle$ap !== void 0 ? _diagnosticsBundle$ap : [];
  }, [diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmEvents]);
  const columns = [{
    name: 'Name',
    field: 'name',
    width: '30%'
  }, {
    name: 'Doc count',
    field: 'docCount',
    render: (_, {
      docCount
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${(0, _formatters.asInteger)(docCount)} docs`
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        cursor: 'pointer'
      }
    }, (0, _formatters.asBigNumber)(docCount))),
    sortable: true
  }, {
    name: '1m',
    field: 'intervals.1m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['1m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval
      });
    }
  }, {
    name: '10m',
    field: 'intervals.10m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['10m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval
      });
    }
  }, {
    name: '60m',
    field: 'intervals.60m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['60m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval
      });
    }
  }, {
    name: 'Actions',
    actions: [{
      name: 'View',
      description: 'View in Discover',
      type: 'icon',
      icon: 'discoverApp',
      onClick: async item => {
        var _discover$locator;
        await (discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({
          query: {
            language: 'kuery',
            query: item.kuery
          },
          dataViewId: _data_view_constants.APM_STATIC_DATA_VIEW_ID,
          timeRange: rangeTo && rangeFrom ? {
            to: rangeTo,
            from: rangeFrom
          } : undefined
        }));
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isImported && diagnosticsBundle ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, "From: ", new Date(diagnosticsBundle.params.start).toISOString()), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, "To: ", new Date(diagnosticsBundle.params.end).toISOString()), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, "Filter: ", (_diagnosticsBundle$pa = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.params.kuery) !== null && _diagnosticsBundle$pa !== void 0 ? _diagnosticsBundle$pa : /*#__PURE__*/_react.default.createElement("em", null, "Empty")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "documents-table",
    items: (0, _lodash.orderBy)(items, sortField, sortDirection),
    sorting: {
      enableAllColumns: true,
      sort: {
        direction: sortDirection,
        field: sortField
      }
    },
    rowHeader: "firstName",
    columns: columns,
    onChange: ({
      sort
    }) => {
      if (sort) {
        setSortField(sort.field);
        setSortDirection(sort.direction);
      }
    }
  }));
}
function IntervalDocCount({
  interval
}) {
  if (interval === undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `${(0, _formatters.asInteger)(interval.metricDocCount)} docs / ${(0, _formatters.asInteger)(interval.eventDocCount)} events`
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      cursor: 'pointer'
    }
  }, (0, _formatters.asBigNumber)(interval.metricDocCount), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontStyle: 'italic',
      fontSize: '80%',
      display: 'inline'
    }
  }, "(", (0, _formatters.asBigNumber)(interval.eventDocCount), " events)")));
}