"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatencyAlertsHistoryChart = LatencyAlertsHistoryChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _document_type = require("../../../../../common/document_type");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _latency_chart_selectors = require("../../../../selectors/latency_chart_selectors");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _timeseries_chart = require("../../../shared/charts/timeseries_chart");
var _helper = require("../../../shared/charts/transaction_charts/helper");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LatencyAlertsHistoryChart({
  serviceName,
  start,
  end,
  transactionType,
  latencyAggregationType,
  environment,
  timeZone,
  ruleId
}) {
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery: '',
    numBuckets: 100,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    http,
    notifications
  } = (0, _public2.useKibana)().services;
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && transactionType && latencyAggregationType && preferred) {
      return callApmApi(`GET /internal/apm/services/{serviceName}/transactions/charts/latency`, {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: '',
            start,
            end,
            transactionType,
            transactionName: undefined,
            latencyAggregationType,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            useDurationSummary: preferred.source.hasDurationSummaryField && latencyAggregationType === _latency_aggregation_types.LatencyAggregationType.avg
          }
        }
      });
    }
  }, [end, environment, latencyAggregationType, serviceName, start, transactionType, preferred]);
  const memoizedData = (0, _react.useMemo)(() => (0, _latency_chart_selectors.getLatencyChartSelector)({
    latencyChart: data,
    latencyAggregationType,
    previousPeriodLabel: ''
  }),
  // It should only update when the data has changed
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data]);
  const {
    currentPeriod,
    previousPeriod
  } = memoizedData;
  const timeseriesLatency = [currentPeriod, previousPeriod].filter(_latency_chart.filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseriesLatency);
  const latencyFormatter = (0, _formatters.getDurationFormatter)(latencyMaxY);
  const {
    data: {
      totalTriggeredAlerts,
      avgTimeToRecoverUS,
      histogramTriggeredAlerts
    },
    isError,
    isLoading
  } = (0, _observabilityAlertDetails.useAlertsHistory)({
    http,
    featureIds: [_ruleDataUtils.AlertConsumers.APM],
    ruleId,
    dateRange: {
      from: start,
      to: end
    }
  });
  if (isError) {
    notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.alertDetails.latencyAlertHistoryChart.error.toastTitle', {
        defaultMessage: 'Latency alerts history chart error'
      }),
      text: _i18n.i18n.translate('xpack.apm.alertDetails.latencyAlertHistoryChart.error.toastDescription', {
        defaultMessage: `An error occurred when fetching latency alert history chart data for {serviceName}`,
        values: {
          serviceName
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, serviceName, _i18n.i18n.translate('xpack.apm.latencyChartHistory.chartTitle', {
    defaultMessage: ' latency alerts history'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.latencyChartHistory.last30days', {
    defaultMessage: 'Last 30 days'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : totalTriggeredAlerts || '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.latencyChartHistory.alertsTriggered', {
    defaultMessage: 'Alerts triggered'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : avgTimeToRecoverUS ? (0, _public.convertTo)({
    unit: 'minutes',
    microseconds: avgTimeToRecoverUS,
    extended: true
  }).formatted : '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.latencyChartHistory.avgTimeToRecover', {
    defaultMessage: 'Avg time to recover'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "latencyChart",
    annotations: [/*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      id: "annotations",
      key: 'annotationsAlertHistory',
      domainType: _charts.AnnotationDomainType.XDomain,
      dataValues: (histogramTriggeredAlerts === null || histogramTriggeredAlerts === void 0 ? void 0 : histogramTriggeredAlerts.filter(annotation => annotation.doc_count > 0).map(annotation => {
        return {
          dataValue: annotation.key,
          header: String(annotation.doc_count),
          details: (0, _moment.default)(annotation.key_as_string).format('yyyy-MM-DD')
        };
      })) || [],
      style: {
        line: {
          strokeWidth: 3,
          stroke: _constants.CHART_ANNOTATION_RED_COLOR,
          opacity: 1
        }
      },
      marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: _constants.CHART_ANNOTATION_RED_COLOR
      }),
      markerBody: annotationData => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: _constants.CHART_ANNOTATION_RED_COLOR
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "white"
      }, annotationData.header)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      })),
      markerPosition: _charts.Position.Top
    })],
    height: 200,
    comparisonEnabled: false,
    offset: '',
    fetchStatus: status,
    timeseries: timeseriesLatency,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    timeZone: timeZone
  }));
}