"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDurationRuleType = TransactionDurationRuleType;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _helper = require("../../../shared/charts/transaction_charts/helper");
var _chart_preview = require("../../ui_components/chart_preview");
var _fields = require("../../utils/fields");
var _helper2 = require("../../utils/helper");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _popover_expression = require("../../ui_components/popover_expression");
var _apm_rule_group_by = require("../../ui_components/apm_rule_group_by");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_preview_helper = require("../../ui_components/chart_preview/chart_preview_helper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSACTION_ALERT_AGGREGATION_TYPES = {
  [_apm_rule_types.AggregationType.Avg]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.avg', {
    defaultMessage: 'Average'
  }),
  [_apm_rule_types.AggregationType.P95]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.95th', {
    defaultMessage: '95th percentile'
  }),
  [_apm_rule_types.AggregationType.P99]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.99th', {
    defaultMessage: '99th percentile'
  })
};
function TransactionDurationRuleType(props) {
  var _latencyChartPreview$, _latencyChartPreview$2;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    aggregationType: _apm_rule_types.AggregationType.Avg,
    threshold: 1500,
    windowSize: 5,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const {
      interval,
      start,
      end
    } = (0, _helper2.getIntervalAndTimeRange)({
      windowSize: params.windowSize,
      windowUnit: params.windowUnit
    });
    if (params.windowSize && start && end) {
      return callApmApi('GET /internal/apm/rule_types/transaction_duration/chart_preview', {
        params: {
          query: {
            aggregationType: params.aggregationType,
            environment: params.environment,
            serviceName: params.serviceName,
            transactionType: params.transactionType,
            transactionName: params.transactionName,
            interval,
            start,
            end,
            groupBy: params.groupBy
          }
        }
      });
    }
  }, [params.aggregationType, params.environment, params.serviceName, params.transactionType, params.transactionName, params.windowSize, params.windowUnit, params.groupBy]);
  const latencyChartPreview = data === null || data === void 0 ? void 0 : data.latencyChartPreview;
  const series = (_latencyChartPreview$ = latencyChartPreview === null || latencyChartPreview === void 0 ? void 0 : latencyChartPreview.series) !== null && _latencyChartPreview$ !== void 0 ? _latencyChartPreview$ : [];
  const hasData = series.length > 0;
  const totalGroups = (_latencyChartPreview$2 = latencyChartPreview === null || latencyChartPreview === void 0 ? void 0 : latencyChartPreview.totalGroups) !== null && _latencyChartPreview$2 !== void 0 ? _latencyChartPreview$2 : 0;
  const maxY = (0, _helper.getMaxY)(series);
  const formatter = (0, _formatters.getDurationFormatter)(maxY);
  const yTickFormat = (0, _helper.getResponseTimeTickFormatter)(formatter);

  // The threshold from the form is in ms. Convert to µs.
  const thresholdMs = params.threshold * 1000;
  const chartPreview = (0, _use_fetcher.isPending)(status) ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.LoadingState, null) : !hasData ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.NoDataState, null) : status === _use_fetcher.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: series,
    threshold: thresholdMs,
    yTickFormat: yTickFormat,
    uiSettings: services.uiSettings,
    timeSize: params.windowSize,
    timeUnit: params.windowUnit,
    totalGroups: totalGroups
  }) : /*#__PURE__*/_react.default.createElement(_chart_preview_helper.ErrorState, null);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group !== null && group !== void 0 ? group : []);
  }, [setRuleParams]);
  const fields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    allowAll: false,
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', undefined);
        setRuleParams('transactionName', undefined);
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value !== '' ? value : _environment_filter_values.ENVIRONMENT_ALL.value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionNameField, {
    currentValue: params.transactionName,
    onChange: value => setRuleParams('transactionName', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: params.aggregationType,
    title: _i18n.i18n.translate('xpack.apm.transactionDurationRuleType.when', {
      defaultMessage: 'When'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmTransactionDurationRuleTypeSelect",
    value: params.aggregationType,
    options: (0, _lodash.map)(TRANSACTION_ALERT_AGGREGATION_TYPES, (label, key) => {
      return {
        text: label,
        value: key
      };
    }),
    onChange: e => setRuleParams('aggregationType', e.target.value),
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_fields.IsAboveField, {
    value: params.threshold,
    unit: _i18n.i18n.translate('xpack.apm.transactionDurationRuleType.ms', {
      defaultMessage: 'ms'
    }),
    onChange: value => setRuleParams('threshold', value || 0)
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    onChangeWindowSize: timeWindowSize => setRuleParams('windowSize', timeWindowSize || ''),
    onChangeWindowUnit: timeWindowUnit => setRuleParams('windowUnit', timeWindowUnit),
    timeWindowSize: params.windowSize,
    timeWindowUnit: params.windowUnit,
    errors: {
      timeWindowSize: [],
      timeWindowUnit: []
    }
  })];
  const groupAlertsBy = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.ruleFlyout.transactionDuration.createAlertPerText', {
      defaultMessage: 'Group alerts by'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.ruleFlyout.transactionDuration.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "transaction.name". By default, alert is created for every unique service.name, service.environment and transaction.type.'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_group_by.APMRuleGroupBy, {
    onChange: onGroupByChange,
    options: {
      groupBy: ruleParams.groupBy
    },
    fields: [_apm.TRANSACTION_NAME],
    preSelectedOptions: [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT, _apm.TRANSACTION_TYPE]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    minimumWindowSize: {
      value: 5,
      unit: _public2.TIME_UNITS.MINUTE
    },
    chartPreview: chartPreview,
    defaultParams: params,
    fields: fields,
    groupAlertsBy: groupAlertsBy,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = TransactionDurationRuleType;
exports.default = _default;