"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDurationAnomalyRuleType = TransactionDurationAnomalyRuleType;
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _fields = require("../../utils/fields");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _popover_expression = require("../../ui_components/popover_expression");
var _select_anomaly_severity = require("./select_anomaly_severity");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDurationAnomalyRuleType(props) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    windowSize: 30,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    anomalySeverityType: _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const fields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', '');
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: /*#__PURE__*/_react.default.createElement(_select_anomaly_severity.AnomalySeverity, {
      type: params.anomalySeverityType
    }),
    title: _i18n.i18n.translate('xpack.apm.transactionDurationAnomalyRuleType.anomalySeverity', {
      defaultMessage: 'Has anomaly with severity'
    })
  }, /*#__PURE__*/_react.default.createElement(_select_anomaly_severity.SelectAnomalySeverity, {
    value: params.anomalySeverityType,
    onChange: value => {
      setRuleParams('anomalySeverityType', value);
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    fields: fields,
    defaultParams: params,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = TransactionDurationAnomalyRuleType;
exports.default = _default;