"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rewriteBodyResponse = exports.bulkGetMaintenanceWindowRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../lib");
var _types = require("../../types");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({
  ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const rewriteBodyResponse = result => ({
  maintenance_windows: result.maintenanceWindows.map(mw => (0, _lib.rewriteMaintenanceWindowRes)(mw)),
  errors: result.errors.map(error => ({
    id: error.id,
    error: error.error,
    message: error.message,
    status_code: error.statusCode
  }))
});
exports.rewriteBodyResponse = rewriteBodyResponse;
const bulkGetMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/_bulk_get`,
    validate: {
      body: bodySchema
    },
    options: {
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const {
      ids
    } = req.body;
    const result = await maintenanceWindowClient.bulkGet({
      ids
    });
    return res.ok({
      body: rewriteBodyResponse(result)
    });
  })));
};
exports.bulkGetMaintenanceWindowRoute = bulkGetMaintenanceWindowRoute;