"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTagsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _types = require("../types");
var _lib = require("./lib");
var _get_tags = require("../rules_client/methods/get_tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const querySchema = _configSchema.schema.object({
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  per_page: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: _get_tags.DEFAULT_TAGS_PER_PAGE,
    min: 1
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string())
});
const rewriteQueryReq = ({
  per_page: perPage,
  ...rest
}) => ({
  ...rest,
  perPage
});
const rewriteBodyRes = ({
  perPage,
  ...rest
}) => ({
  ...rest,
  per_page: perPage
});
const getRuleTagsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_tags`,
    validate: {
      query: querySchema
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const options = rewriteQueryReq(req.query);
    const tagsResult = await rulesClient.getTags(options);
    return res.ok({
      body: rewriteBodyRes(tagsResult)
    });
  })));
};
exports.getRuleTagsRoute = getRuleTagsRoute;