"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = create;
var _moment = _interopRequireDefault(require("moment"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _server = require("@kbn/core/server");
var _get_maintenance_window_from_raw = require("../get_maintenance_window_from_raw");
var _generate_maintenance_window_events = require("../generate_maintenance_window_events");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function create(context, params) {
  const {
    savedObjectsClient,
    getModificationMetadata,
    logger
  } = context;
  const {
    title,
    duration,
    rRule
  } = params;
  const id = _server.SavedObjectsUtils.generateId();
  const expirationDate = (0, _moment.default)().utc().add(1, 'year').toISOString();
  const modificationMetadata = await getModificationMetadata();
  try {
    const events = (0, _generate_maintenance_window_events.generateMaintenanceWindowEvents)({
      rRule,
      expirationDate,
      duration
    });
    const result = await savedObjectsClient.create(_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE, {
      title,
      enabled: true,
      expirationDate,
      rRule,
      duration,
      events,
      ...modificationMetadata
    }, {
      id
    });
    return (0, _get_maintenance_window_from_raw.getMaintenanceWindowFromRaw)({
      attributes: result.attributes,
      id: result.id
    });
  } catch (e) {
    const errorMessage = `Failed to create maintenance window, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}