"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGet = bulkGet;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _get_maintenance_window_from_raw = require("../get_maintenance_window_from_raw");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function bulkGet(context, params) {
  const {
    savedObjectsClient,
    logger
  } = context;
  const {
    ids
  } = params;
  const bulkGetObjects = ids.map(id => ({
    id,
    type: _common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE
  }));
  try {
    const {
      saved_objects: savedObjects
    } = await savedObjectsClient.bulkGet(bulkGetObjects);
    const maintenanceWindows = [];
    const errors = [];
    savedObjects.forEach(so => {
      if (so.error) {
        errors.push({
          id: so.id,
          error: so.error.error,
          message: so.error.message,
          statusCode: so.error.statusCode
        });
      } else {
        maintenanceWindows.push((0, _get_maintenance_window_from_raw.getMaintenanceWindowFromRaw)({
          id: so.id,
          attributes: so.attributes
        }));
      }
    });
    return {
      maintenanceWindows,
      errors
    };
  } catch (e) {
    const errorMessage = `Failed to bulk get maintenance window for ids: ${ids}, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}