"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stripFrameworkFields = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedFrameworkFields = new Set([_ruleDataUtils.ALERT_REASON]);

/**
 * Remove framework fields from the alert payload reported by
 * the rule type. Fields are considered framework fields if they are
 * defined in the "alertFieldMap". Framework fields should only be
 * set by the alerting framework during rule execution.
 */
const stripFrameworkFields = payload => {
  const keysToStrip = Object.keys(_alertsAsDataUtils.alertFieldMap).filter(key => !allowedFrameworkFields.has(key));
  return (0, _lodash.omit)(payload, keysToStrip);
};
exports.stripFrameworkFields = stripFrameworkFields;