"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _alert_navigation_registry = require("./alert_navigation_registry");
var _alert_api = require("./services/alert_api");
var _common = require("../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class AlertingPublicPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "alertNavigationRegistry", void 0);
    this.initContext = initContext;
  }
  setup(core, plugins) {
    this.alertNavigationRegistry = new _alert_navigation_registry.AlertNavigationRegistry();
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const registerNavigation = async (applicationId, ruleTypeId, handler) => {
      this.alertNavigationRegistry.register(applicationId, ruleTypeId, handler);
    };
    const registerDefaultNavigation = async (applicationId, handler) => this.alertNavigationRegistry.registerDefault(applicationId, handler);
    if (_common.ENABLE_MAINTENANCE_WINDOWS) {
      plugins.management.sections.section.insightsAndAlerting.registerApp({
        id: _common.MAINTENANCE_WINDOWS_APP_ID,
        title: _i18n.i18n.translate('xpack.alerting.management.section.title', {
          defaultMessage: 'Maintenance Windows'
        }),
        async mount(params) {
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/maintenance_windows')));
          const [coreStart, pluginsStart] = await core.getStartServices();
          return renderApp({
            core: coreStart,
            plugins: pluginsStart,
            mountParams: params,
            kibanaVersion
          });
        }
      });
    }
    return {
      registerNavigation,
      registerDefaultNavigation
    };
  }
  start(core) {
    return {
      getNavigation: async ruleId => {
        const rule = await (0, _alert_api.loadRule)({
          http: core.http,
          ruleId
        });
        const ruleType = await (0, _alert_api.loadRuleType)({
          http: core.http,
          id: rule.alertTypeId
        });
        if (!ruleType) {
          // eslint-disable-next-line no-console
          console.log(`Unable to get navigation for rule type "${rule.alertTypeId}" because it is not registered on the server side.`);
          return;
        }
        if (this.alertNavigationRegistry.has(rule.consumer, ruleType)) {
          const navigationHandler = this.alertNavigationRegistry.get(rule.consumer, ruleType);
          return navigationHandler(rule);
        }
        if (rule.viewInAppRelativeUrl) {
          return rule.viewInAppRelativeUrl;
        }
      }
    };
  }
}
exports.AlertingPublicPlugin = AlertingPublicPlugin;