"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortDirection = exports.RRuleFrequencyMap = exports.RRuleFrequency = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RRuleFrequency;
exports.RRuleFrequency = RRuleFrequency;
(function (RRuleFrequency) {
  RRuleFrequency[RRuleFrequency["YEARLY"] = 0] = "YEARLY";
  RRuleFrequency[RRuleFrequency["MONTHLY"] = 1] = "MONTHLY";
  RRuleFrequency[RRuleFrequency["WEEKLY"] = 2] = "WEEKLY";
  RRuleFrequency[RRuleFrequency["DAILY"] = 3] = "DAILY";
})(RRuleFrequency || (exports.RRuleFrequency = RRuleFrequency = {}));
const RRuleFrequencyMap = {
  '0': RRuleFrequency.YEARLY,
  '1': RRuleFrequency.MONTHLY,
  '2': RRuleFrequency.WEEKLY,
  '3': RRuleFrequency.DAILY
};
exports.RRuleFrequencyMap = RRuleFrequencyMap;
let SortDirection;
exports.SortDirection = SortDirection;
(function (SortDirection) {
  SortDirection["asc"] = "asc";
  SortDirection["desc"] = "desc";
})(SortDirection || (exports.SortDirection = SortDirection = {}));