"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPresets = void 0;
var _constants = require("../constants");
var _get_initial_by_weekday = require("./get_initial_by_weekday");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPresets = startDate => {
  return {
    [_constants.Frequency.DAILY]: {
      interval: 1
    },
    [_constants.Frequency.WEEKLY]: {
      interval: 1,
      byweekday: (0, _get_initial_by_weekday.getInitialByWeekday)([], startDate)
    },
    [_constants.Frequency.MONTHLY]: {
      interval: 1,
      bymonth: 'weekday'
    },
    [_constants.Frequency.YEARLY]: {
      interval: 1
    }
  };
};
exports.getPresets = getPresets;