"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusFilter = /*#__PURE__*/_react.default.memo(({
  query,
  onChange
}) => {
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    const options = selectedOptions.includes(newOption) ? selectedOptions.filter(option => option !== newOption) : [...selectedOptions, newOption];
    setSelectedOptions(options);
    let q = query.removeSimpleFieldClauses('status').removeOrFieldClauses('status');
    if (options.length > 0) {
      q = options.reduce((acc, curr) => {
        return acc.addOrFieldValue('status', curr, true, 'eq');
      }, q);
    }
    onChange === null || onChange === void 0 ? void 0 : onChange(q);
  }, [query, onChange, selectedOptions]);
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "status-filter-button",
      iconType: "arrowDown",
      hasActiveFilters: selectedOptions.length > 0,
      numActiveFilters: selectedOptions.length,
      numFilters: selectedOptions.length,
      onClick: openPopover
    }, i18n.TABLE_STATUS)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.STATUS_OPTIONS.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: status.value,
      "data-test-subj": `status-filter-${status.value}`,
      onClick: onFilterItemClick(status.value),
      checked: selectedOptions.includes(status.value) ? 'on' : undefined
    }, status.name);
  }))));
});
exports.StatusFilter = StatusFilter;
StatusFilter.displayName = 'StatusFilter';